/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.RedissonObject;
import org.redisson.ScanIterator;
import org.redisson.ScanResult;
import org.redisson.api.RFuture;
import org.redisson.api.RLockReactive;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.api.RSet;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.RedisClient;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetReactive<V> {
    private final RSet<V> instance;
    private final RedissonReactiveClient redisson;

    public RedissonSetReactive(RSet<V> instance, RedissonReactiveClient redisson) {
        this.instance = instance;
        this.redisson = redisson;
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<Object>(){

            @Override
            public RFuture<Boolean> add(Object e) {
                return RedissonSetReactive.this.instance.addAsync(e);
            }
        }.addAll(c);
    }

    public Publisher<V> iterator(int count) {
        return this.iterator(null, count);
    }

    public Publisher<V> iterator(String pattern) {
        return this.iterator(pattern, 10);
    }

    public Publisher<V> iterator(final String pattern, final int count) {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected RFuture<ScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((ScanIterator)((Object)RedissonSetReactive.this.instance)).scanIteratorAsync(((RedissonObject)((Object)RedissonSetReactive.this.instance)).getRawName(), client, nextIterPos, pattern, count);
            }
        });
    }

    public Publisher<V> iterator() {
        return this.iterator(null, 10);
    }

    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreReactive getSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockReactive getFairLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockReactive getReadWriteLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockReactive getLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "lock");
        return this.redisson.getLock(name);
    }
}

