/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import org.redisson.RedissonLockEntry;
import org.redisson.misc.RPromise;
import org.redisson.pubsub.PublishSubscribe;

public class SemaphorePubSub
extends PublishSubscribe<RedissonLockEntry> {
    @Override
    protected RedissonLockEntry createEntry(RPromise<RedissonLockEntry> newPromise) {
        return new RedissonLockEntry(newPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onMessage(RedissonLockEntry value, Long message) {
        value.getLatch().release(message.intValue());
        while (true) {
            Runnable runnableToExecute = null;
            RedissonLockEntry redissonLockEntry = value;
            synchronized (redissonLockEntry) {
                Runnable runnable = value.getListeners().poll();
                if (runnable != null) {
                    if (value.getLatch().tryAcquire()) {
                        runnableToExecute = runnable;
                    } else {
                        value.addListener(runnable);
                    }
                }
            }
            if (runnableToExecute == null) break;
            runnableToExecute.run();
        }
    }
}

