/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.redisson.RedissonQueue;
import org.redisson.api.RDeque;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.ListFirstObjectDecoder;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonDeque<V>
extends RedissonQueue<V>
implements RDeque<V> {
    private static final RedisCommand<Void> RPUSH_VOID = new RedisCommand<Void>("RPUSH", new VoidReplayConvertor(), 2, RedisCommand.ValueType.OBJECTS);
    private static final RedisCommand<Object> LRANGE_SINGLE = new RedisCommand<Object>("LRANGE", new ListFirstObjectDecoder());

    protected RedissonDeque(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public RedissonDeque(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
    }

    @Override
    public void addFirst(V e) {
        this.get(this.addFirstAsync(e));
    }

    @Override
    public RFuture<Void> addFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_VOID, this.getName(), e);
    }

    @Override
    public void addLast(V e) {
        this.get(this.addLastAsync(e));
    }

    @Override
    public RFuture<Void> addLastAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RPUSH_VOID, this.getName(), e);
    }

    @Override
    public Iterator<V> descendingIterator() {
        return new Iterator<V>(){
            private int currentIndex;
            private boolean removeExecuted;
            {
                this.currentIndex = RedissonDeque.this.size();
            }

            @Override
            public boolean hasNext() {
                int size = RedissonDeque.this.size();
                return this.currentIndex > 0 && size > 0;
            }

            @Override
            public V next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No such element at index " + this.currentIndex);
                }
                --this.currentIndex;
                this.removeExecuted = false;
                return RedissonDeque.this.get(this.currentIndex);
            }

            @Override
            public void remove() {
                if (this.removeExecuted) {
                    throw new IllegalStateException("Element been already deleted");
                }
                RedissonDeque.this.remove(this.currentIndex);
                ++this.currentIndex;
                this.removeExecuted = true;
            }
        };
    }

    @Override
    public RFuture<V> getLastAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, LRANGE_SINGLE, this.getName(), -1, -1);
    }

    @Override
    public V getLast() {
        V result = this.get(this.getLastAsync());
        if (result == null) {
            throw new NoSuchElementException();
        }
        return result;
    }

    @Override
    public boolean offerFirst(V e) {
        return this.get(this.offerFirstAsync(e));
    }

    @Override
    public RFuture<Boolean> offerFirstAsync(V e) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.LPUSH_BOOLEAN, this.getName(), e);
    }

    @Override
    public RFuture<Boolean> offerLastAsync(V e) {
        return this.offerAsync(e);
    }

    @Override
    public boolean offerLast(V e) {
        return this.get(this.offerLastAsync(e));
    }

    @Override
    public RFuture<V> peekFirstAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peekFirst() {
        return this.get(this.peekFirstAsync());
    }

    @Override
    public RFuture<V> peekLastAsync() {
        return this.getLastAsync();
    }

    @Override
    public V peekLast() {
        return this.get(this.getLastAsync());
    }

    @Override
    public RFuture<V> pollFirstAsync() {
        return this.pollAsync();
    }

    @Override
    public V pollFirst() {
        return this.poll();
    }

    @Override
    public RFuture<V> pollLastAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public V pollLast() {
        return this.get(this.pollLastAsync());
    }

    @Override
    public RFuture<V> popAsync() {
        return this.pollAsync();
    }

    @Override
    public V pop() {
        return this.removeFirst();
    }

    @Override
    public RFuture<Void> pushAsync(V e) {
        return this.addFirstAsync(e);
    }

    @Override
    public void push(V e) {
        this.addFirst(e);
    }

    @Override
    public RFuture<Boolean> removeFirstOccurrenceAsync(Object o) {
        return this.removeAsync(o, 1);
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.remove(o, 1);
    }

    @Override
    public RFuture<V> removeFirstAsync() {
        return this.pollAsync();
    }

    @Override
    public RFuture<V> removeLastAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.RPOP, this.getName());
    }

    @Override
    public V removeLast() {
        V value = this.get(this.removeLastAsync());
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public RFuture<Boolean> removeLastOccurrenceAsync(Object o) {
        return this.removeAsync(o, -1);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.remove(o, -1);
    }
}

