/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.internal.PlatformDependent;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.redisson.misc.Cache;

public abstract class AbstractCacheMap<K, V>
implements Cache<K, V> {
    final int size;
    final ConcurrentMap<K, CachedValue> map = PlatformDependent.newConcurrentHashMap();
    private final long timeToLiveInMillis;
    private final long maxIdleInMillis;

    public AbstractCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        if (size < 0) {
            throw new IllegalArgumentException("Size can't be " + size);
        }
        this.size = size;
        this.maxIdleInMillis = maxIdleInMillis;
        this.timeToLiveInMillis = timeToLiveInMillis;
    }

    protected void onValueRead(CachedValue value) {
    }

    protected void onValueRemove(CachedValue value) {
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        CachedValue entry = (CachedValue)this.map.get(key);
        if (entry == null) {
            return false;
        }
        if (entry.isExpired()) {
            if (this.map.remove(key, entry)) {
                this.onValueRemove(entry);
                return false;
            }
            return this.containsKey(key);
        }
        return true;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            throw new NullPointerException();
        }
        for (Map.Entry entry : this.map.entrySet()) {
            CachedValue cachedValue = (CachedValue)entry.getValue();
            if (!cachedValue.getValue().equals(value)) continue;
            if (cachedValue.isExpired()) {
                if (!this.map.remove(cachedValue.getKey(), cachedValue)) continue;
                this.onValueRemove(cachedValue);
                continue;
            }
            this.readValue(cachedValue);
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        CachedValue entry = (CachedValue)this.map.get(key);
        if (entry == null) {
            return null;
        }
        if (entry.isExpired()) {
            if (this.map.remove(key, entry)) {
                this.onValueRemove(entry);
                return null;
            }
            return this.get(key);
        }
        return this.readValue(entry);
    }

    protected V readValue(CachedValue entry) {
        this.onValueRead(entry);
        return (V)entry.getValue();
    }

    @Override
    public V put(K key, V value) {
        return this.put(key, value, this.timeToLiveInMillis, TimeUnit.MILLISECONDS, this.maxIdleInMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public V put(K key, V value, long ttl, TimeUnit ttlUnit, long maxIdleTime, TimeUnit maxIdleUnit) {
        CachedValue entry = this.create(key, value, ttlUnit.toMillis(ttl), maxIdleUnit.toMillis(maxIdleTime));
        if (this.isFull(key) && !this.removeExpiredEntries()) {
            this.onMapFull();
        }
        this.onValueCreate(entry);
        CachedValue prevCachedValue = this.map.put(key, entry);
        if (prevCachedValue != null) {
            this.onValueRemove(prevCachedValue);
            if (!prevCachedValue.isExpired()) {
                return (V)prevCachedValue.getValue();
            }
        }
        return null;
    }

    protected CachedValue create(K key, V value, long ttl, long maxIdleTime) {
        return new CachedValue(key, value, ttl, maxIdleTime);
    }

    protected void onValueCreate(CachedValue entry) {
    }

    private boolean removeExpiredEntries() {
        boolean removed = false;
        for (CachedValue value : this.map.values()) {
            if (!value.isExpired() || !this.map.remove(value.getKey(), value)) continue;
            this.onValueRemove(value);
            removed = true;
        }
        return removed;
    }

    protected abstract void onMapFull();

    boolean isFull() {
        if (this.size == 0) {
            return false;
        }
        return this.map.size() >= this.size;
    }

    private boolean isFull(K key) {
        if (this.size == 0) {
            return false;
        }
        if (this.map.size() >= this.size) {
            return !this.map.containsKey(key);
        }
        return false;
    }

    @Override
    public V remove(Object key) {
        CachedValue entry = (CachedValue)this.map.remove(key);
        if (entry != null) {
            this.onValueRemove(entry);
            if (!entry.isExpired()) {
                return (V)entry.getValue();
            }
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.removeExpiredEntries();
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Set<K> keySet() {
        this.removeExpiredEntries();
        return new KeySet();
    }

    @Override
    public Collection<V> values() {
        this.removeExpiredEntries();
        return new Values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        this.removeExpiredEntries();
        return new EntrySet();
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new MapIterator<Map.Entry<K, V>>(){

                @Override
                public Map.Entry<K, V> next() {
                    if (this.mapEntry == null) {
                        throw new NoSuchElementException();
                    }
                    AbstractMap.SimpleEntry result = new AbstractMap.SimpleEntry(this.mapEntry.getKey(), AbstractCacheMap.this.readValue((CachedValue)this.mapEntry.getValue()));
                    this.mapEntry = null;
                    return result;
                }

                @Override
                public void remove() {
                    if (this.mapEntry == null) {
                        throw new IllegalStateException();
                    }
                    AbstractCacheMap.this.map.remove(this.mapEntry.getKey(), this.mapEntry.getValue());
                    this.mapEntry = null;
                }
            };
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = AbstractCacheMap.this.get(key);
            return value != null && value.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return AbstractCacheMap.this.map.remove(key, value);
            }
            return false;
        }

        @Override
        public final int size() {
            return AbstractCacheMap.this.size();
        }

        @Override
        public final void clear() {
            AbstractCacheMap.this.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new MapIterator<V>(){

                @Override
                public V next() {
                    if (this.mapEntry == null) {
                        throw new NoSuchElementException();
                    }
                    Object value = AbstractCacheMap.this.readValue((CachedValue)this.mapEntry.getValue());
                    this.mapEntry = null;
                    return value;
                }

                @Override
                public void remove() {
                    if (this.mapEntry == null) {
                        throw new IllegalStateException();
                    }
                    AbstractCacheMap.this.map.remove(this.mapEntry.getKey(), this.mapEntry.getValue());
                    this.mapEntry = null;
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return AbstractCacheMap.this.containsValue(o);
        }

        @Override
        public int size() {
            return AbstractCacheMap.this.size();
        }

        @Override
        public void clear() {
            AbstractCacheMap.this.clear();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new MapIterator<K>(){

                @Override
                public K next() {
                    if (this.mapEntry == null) {
                        throw new NoSuchElementException();
                    }
                    Object key = this.mapEntry.getKey();
                    this.mapEntry = null;
                    return key;
                }

                @Override
                public void remove() {
                    if (this.mapEntry == null) {
                        throw new IllegalStateException();
                    }
                    AbstractCacheMap.this.map.remove(this.mapEntry.getKey());
                    this.mapEntry = null;
                }
            };
        }

        @Override
        public boolean contains(Object o) {
            return AbstractCacheMap.this.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return AbstractCacheMap.this.remove(o) != null;
        }

        @Override
        public int size() {
            return AbstractCacheMap.this.size();
        }

        @Override
        public void clear() {
            AbstractCacheMap.this.clear();
        }
    }

    abstract class MapIterator<M>
    implements Iterator<M> {
        final Iterator<Map.Entry<K, CachedValue>> keyIterator;
        Map.Entry<K, CachedValue> mapEntry;

        MapIterator() {
            this.keyIterator = AbstractCacheMap.this.map.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.mapEntry != null) {
                return true;
            }
            this.mapEntry = null;
            while (this.keyIterator.hasNext()) {
                Map.Entry entry = this.keyIterator.next();
                if (entry.getValue().isExpired()) continue;
                this.mapEntry = entry;
                break;
            }
            return this.mapEntry != null;
        }
    }

    public static class CachedValue {
        private final Object key;
        private final Object value;
        long ttl;
        long maxIdleTime;
        long creationTime;
        long lastAccess;

        public CachedValue(Object key, Object value, long ttl, long maxIdleTime) {
            this.value = value;
            this.ttl = ttl;
            this.key = key;
            this.maxIdleTime = maxIdleTime;
            this.lastAccess = this.creationTime = System.currentTimeMillis();
        }

        public boolean isExpired() {
            boolean result = false;
            long currentTime = System.currentTimeMillis();
            if (this.ttl != 0L && this.creationTime + this.ttl < currentTime) {
                result = true;
            }
            if (this.maxIdleTime != 0L && this.lastAccess + this.maxIdleTime < currentTime) {
                result = true;
            }
            return result;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            this.lastAccess = System.currentTimeMillis();
            return this.value;
        }

        public String toString() {
            return "CachedValue [key=" + this.key + ", value=" + this.value + "]";
        }
    }
}

