/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.misc.URLBuilder;

public class SentinelServersConfig
extends BaseMasterSlaveServersConfig<SentinelServersConfig> {
    private List<URL> sentinelAddresses = new ArrayList<URL>();
    private String masterName;
    private int database = 0;

    public SentinelServersConfig() {
    }

    SentinelServersConfig(SentinelServersConfig config) {
        super(config);
        this.setSentinelAddresses(config.getSentinelAddresses());
        this.setMasterName(config.getMasterName());
        this.setDatabase(config.getDatabase());
    }

    public SentinelServersConfig setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public SentinelServersConfig addSentinelAddress(String ... addresses) {
        for (String address : addresses) {
            this.sentinelAddresses.add(URLBuilder.create(address));
        }
        return this;
    }

    public List<URL> getSentinelAddresses() {
        return this.sentinelAddresses;
    }

    void setSentinelAddresses(List<URL> sentinelAddresses) {
        this.sentinelAddresses = sentinelAddresses;
    }

    public SentinelServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }
}

