/*
 * Decompiled with CFR 0.152.
 */
package reactor.rx.stream;

import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.support.Exceptions;
import reactor.rx.Stream;

public final class ErrorStream<O, T extends Throwable>
extends Stream<O> {
    private static final Subscription ERROR_SUB = new Subscription(){

        @Override
        public void request(long n) {
        }

        @Override
        public void cancel() {
        }
    };
    private final T error;

    public ErrorStream(T value) {
        this.error = value;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.error;
    }

    @Override
    public void subscribe(Subscriber<? super O> s) {
        try {
            s.onSubscribe(ERROR_SUB);
        }
        catch (Throwable throwable) {
            Exceptions.throwIfFatal(throwable);
            s.onError(throwable);
        }
        s.onError((Throwable)this.error);
    }
}

