/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.balancer;

import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.internal.PlatformDependent;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.PubSubConnectionPool;
import org.redisson.connection.pool.SlaveConnectionPool;
import org.redisson.misc.RPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancerManager {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ConnectionManager connectionManager;
    private final Map<InetSocketAddress, ClientConnectionsEntry> addr2Entry = PlatformDependent.newConcurrentHashMap();
    private final PubSubConnectionPool pubSubConnectionPool;
    private final SlaveConnectionPool slaveConnectionPool;

    public LoadBalancerManager(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry entry) {
        this.connectionManager = connectionManager;
        this.slaveConnectionPool = new SlaveConnectionPool(config, connectionManager, entry);
        this.pubSubConnectionPool = new PubSubConnectionPool(config, connectionManager, entry);
    }

    public RFuture<Void> add(final ClientConnectionsEntry entry) {
        final RPromise<Void> result = this.connectionManager.newPromise();
        FutureListener<Void> listener = new FutureListener<Void>(){
            AtomicInteger counter = new AtomicInteger(2);

            @Override
            public void operationComplete(Future<Void> future) throws Exception {
                if (!future.isSuccess()) {
                    result.tryFailure(future.cause());
                    return;
                }
                if (this.counter.decrementAndGet() == 0) {
                    LoadBalancerManager.this.addr2Entry.put(entry.getClient().getAddr(), entry);
                    result.trySuccess(null);
                }
            }
        };
        RFuture slaveFuture = this.slaveConnectionPool.add(entry);
        slaveFuture.addListener(listener);
        RFuture pubSubFuture = this.pubSubConnectionPool.add(entry);
        pubSubFuture.addListener(listener);
        return result;
    }

    public int getAvailableClients() {
        int count = 0;
        for (ClientConnectionsEntry connectionEntry : this.addr2Entry.values()) {
            if (connectionEntry.isFreezed()) continue;
            ++count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean unfreeze(String host, int port, ClientConnectionsEntry.FreezeReason freezeReason) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        ClientConnectionsEntry entry = this.addr2Entry.get(addr);
        if (entry == null) {
            throw new IllegalStateException("Can't find " + addr + " in slaves!");
        }
        ClientConnectionsEntry clientConnectionsEntry = entry;
        synchronized (clientConnectionsEntry) {
            if (!entry.isFreezed()) {
                return false;
            }
            if (freezeReason == ClientConnectionsEntry.FreezeReason.RECONNECT && entry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT || freezeReason != ClientConnectionsEntry.FreezeReason.RECONNECT) {
                entry.resetFailedAttempts();
                entry.setFreezed(false);
                entry.setFreezeReason(null);
                return true;
            }
        }
        return false;
    }

    public ClientConnectionsEntry freeze(String host, int port, ClientConnectionsEntry.FreezeReason freezeReason) {
        InetSocketAddress addr = new InetSocketAddress(host, port);
        ClientConnectionsEntry connectionEntry = this.addr2Entry.get(addr);
        return this.freeze(connectionEntry, freezeReason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientConnectionsEntry freeze(ClientConnectionsEntry connectionEntry, ClientConnectionsEntry.FreezeReason freezeReason) {
        if (connectionEntry == null) {
            return null;
        }
        ClientConnectionsEntry clientConnectionsEntry = connectionEntry;
        synchronized (clientConnectionsEntry) {
            if (connectionEntry.getFreezeReason() == null || connectionEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.RECONNECT) {
                connectionEntry.setFreezed(true);
                connectionEntry.setFreezeReason(freezeReason);
                return connectionEntry;
            }
            if (connectionEntry.isFreezed()) {
                return null;
            }
        }
        return connectionEntry;
    }

    public RFuture<RedisPubSubConnection> nextPubSubConnection() {
        return this.pubSubConnectionPool.get();
    }

    public RFuture<RedisConnection> getConnection(InetSocketAddress addr) {
        ClientConnectionsEntry entry = this.addr2Entry.get(addr);
        if (entry != null) {
            return this.slaveConnectionPool.get(entry);
        }
        RedisConnectionException exception = new RedisConnectionException("Can't find entry for " + addr);
        return this.connectionManager.newFailedFuture(exception);
    }

    public RFuture<RedisConnection> nextConnection() {
        return this.slaveConnectionPool.get();
    }

    public void returnPubSubConnection(RedisPubSubConnection connection) {
        ClientConnectionsEntry entry = this.addr2Entry.get(connection.getRedisClient().getAddr());
        this.pubSubConnectionPool.returnConnection(entry, connection);
    }

    public void returnConnection(RedisConnection connection) {
        ClientConnectionsEntry entry = this.addr2Entry.get(connection.getRedisClient().getAddr());
        this.slaveConnectionPool.returnConnection(entry, connection);
    }

    public void shutdown() {
        for (ClientConnectionsEntry entry : this.addr2Entry.values()) {
            entry.getClient().shutdown();
        }
    }

    public void shutdownAsync() {
        for (ClientConnectionsEntry entry : this.addr2Entry.values()) {
            this.connectionManager.shutdownAsync(entry.getClient());
        }
    }
}

