/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.EvictionScheduler;
import org.redisson.RedissonBaseIterator;
import org.redisson.RedissonExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RSetCache;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSetCache<V>
extends RedissonExpirable
implements RSetCache<V> {
    public RedissonSetCache(EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        evictionScheduler.schedule(this.getName());
    }

    public RedissonSetCache(Codec codec, EvictionScheduler evictionScheduler, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        evictionScheduler.schedule(this.getName());
    }

    @Override
    public int size() {
        return this.get(this.sizeAsync());
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.ZCARD_INT, this.getName());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.get(this.containsAsync(o));
    }

    @Override
    public RFuture<Boolean> containsAsync(Object o) {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisStrictCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5), "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[2]); if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;else return 1;end;else return 0;end; ", Arrays.asList(this.getName()), System.currentTimeMillis(), o);
    }

    ListScanResult<V> scanIterator(InetSocketAddress client, long startPos) {
        RFuture<ListScanResult<V>> f = this.scanIteratorAsync(client, startPos);
        return this.get(f);
    }

    public RFuture<ListScanResult<V>> scanIteratorAsync(InetSocketAddress client, long startPos) {
        return this.commandExecutor.evalReadAsync(client, this.getName(), this.codec, RedisCommands.EVAL_ZSCAN, "local result = {}; local res = redis.call('zscan', KEYS[1], ARGV[1]); for i, value in ipairs(res[2]) do if i % 2 == 0 then local expireDate = value; if tonumber(expireDate) > tonumber(ARGV[2]) then table.insert(result, res[2][i-1]); end; end;end;return {res[1], result};", Arrays.asList(this.getName()), startPos, System.currentTimeMillis());
    }

    @Override
    public Iterator<V> iterator() {
        return new RedissonBaseIterator<V>(){

            @Override
            ListScanResult<V> iterator(InetSocketAddress client, long nextIterPos) {
                return RedissonSetCache.this.scanIterator(client, nextIterPos);
            }

            @Override
            void remove(V value) {
                RedissonSetCache.this.remove(value);
            }
        };
    }

    @Override
    public Set<V> readAll() {
        return this.get(this.readAllAsync());
    }

    @Override
    public RFuture<Set<V>> readAllAsync() {
        return this.readAllAsync(RedisCommands.ZRANGEBYSCORE);
    }

    private RFuture<?> readAllAsync(RedisCommand<? extends Collection<?>> command) {
        return this.commandExecutor.readAsync(this.getName(), this.codec, command, this.getName(), System.currentTimeMillis(), 92233720368547758L);
    }

    private RFuture<List<Object>> readAllasListAsync() {
        return this.readAllAsync(RedisCommands.ZRANGEBYSCORE_LIST);
    }

    @Override
    public Object[] toArray() {
        List<Object> res = this.get(this.readAllasListAsync());
        return res.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        List<Object> res = this.get(this.readAllasListAsync());
        return res.toArray(a);
    }

    @Override
    public boolean add(V e) {
        return this.get(this.addAsync(e));
    }

    @Override
    public boolean add(V value, long ttl, TimeUnit unit) {
        return this.get(this.addAsync(value, ttl, unit));
    }

    @Override
    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        if (ttl < 0L) {
            throw new IllegalArgumentException("TTL can't be negative");
        }
        if (ttl == 0L) {
            return this.addAsync(value);
        }
        if (unit == null) {
            throw new NullPointerException("TimeUnit param can't be null");
        }
        byte[] objectState = this.encode(value);
        long timeoutDate = System.currentTimeMillis() + unit.toMillis(ttl);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local expireDateScore = redis.call('zscore', KEYS[1], ARGV[3]); redis.call('zadd', KEYS[1], ARGV[2], ARGV[3]); if expireDateScore ~= false and tonumber(expireDateScore) > tonumber(ARGV[1]) then return 0;end; return 1; ", Arrays.asList(this.getName()), System.currentTimeMillis(), timeoutDate, objectState);
    }

    @Override
    public RFuture<Boolean> addAsync(V value) {
        return this.addAsync(value, 92233720368547758L - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREM, this.getName(), o);
    }

    @Override
    public boolean remove(Object value) {
        return this.get(this.removeAsync(value));
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.get(this.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(true);
        }
        ArrayList<Long> params = new ArrayList<Long>(c.size() + 1);
        params.add(System.currentTimeMillis());
        params.addAll(c);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, new RedisCommand<Boolean>("EVAL", new BooleanReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS), "for j = 2, #ARGV, 1 do local expireDateScore = redis.call('zscore', KEYS[1], ARGV[j]) if expireDateScore ~= false then if tonumber(expireDateScore) <= tonumber(ARGV[1]) then return 0;end; else return 0;end; end; return 1; ", Collections.singletonList(this.getName()), params.toArray());
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        return this.get(this.addAllAsync(c));
    }

    @Override
    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2 + 1);
        params.add(this.getName());
        for (V value : c) {
            byte[] objectState = this.encode(value);
            params.add(score);
            params.add(objectState);
        }
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZADD_BOOL_RAW, params.toArray());
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.get(this.retainAllAsync(c));
    }

    @Override
    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.deleteAsync();
        }
        long score = 92233720368547758L - System.currentTimeMillis();
        ArrayList<Object> params = new ArrayList<Object>(c.size() * 2);
        for (Object object : c) {
            params.add(score);
            params.add(this.encode(object));
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('zadd', KEYS[2], unpack(ARGV)); local prevSize = redis.call('zcard', KEYS[1]); local size = redis.call('zinterstore', KEYS[1], #ARGV/2, KEYS[1], KEYS[2], 'aggregate', 'min');redis.call('del', KEYS[2]); return size ~= prevSize and 1 or 0; ", Arrays.asList(this.getName(), "redisson_temp__{" + this.getName() + "}"), params.toArray());
    }

    @Override
    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        if (c.isEmpty()) {
            return this.newSucceededFuture(false);
        }
        ArrayList<String> params = new ArrayList<String>(c.size() + 1);
        params.add(this.getName());
        params.addAll(c);
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.ZREM, params.toArray());
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.get(this.removeAllAsync(c));
    }

    @Override
    public void clear() {
        this.delete();
    }
}

