/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.redisson.RedissonList;
import org.redisson.api.RListReactive;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.LongReplayConvertor;
import org.redisson.command.CommandReactiveExecutor;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.RedissonExpirableReactive;
import reactor.fn.BiFunction;
import reactor.fn.Function;
import reactor.rx.Stream;
import reactor.rx.Streams;
import reactor.rx.subscription.ReactiveSubscription;

public class RedissonListReactive<V>
extends RedissonExpirableReactive
implements RListReactive<V> {
    private final RedissonList<V> instance;

    public RedissonListReactive(CommandReactiveExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.instance = new RedissonList(commandExecutor, name);
    }

    public RedissonListReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.instance = new RedissonList(codec, commandExecutor, name);
    }

    @Override
    public Publisher<Long> size() {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.LLEN, this.getName());
    }

    @Override
    public Publisher<V> descendingIterator() {
        return this.iterator(-1, false);
    }

    @Override
    public Publisher<V> iterator() {
        return this.iterator(0, true);
    }

    @Override
    public Publisher<V> descendingIterator(int startIndex) {
        return this.iterator(startIndex, false);
    }

    @Override
    public Publisher<V> iterator(int startIndex) {
        return this.iterator(startIndex, true);
    }

    private Publisher<V> iterator(final int startIndex, final boolean forward) {
        return new Stream<V>(){

            @Override
            public void subscribe(Subscriber<? super V> t) {
                t.onSubscribe(new ReactiveSubscription<V>(this, t){
                    private int currentIndex;
                    {
                        this.currentIndex = startIndex;
                    }

                    @Override
                    protected void onRequest(final long n) {
                        final 1 m = this;
                        RedissonListReactive.this.get(this.currentIndex).subscribe(new Subscriber<V>(){
                            V currValue;

                            @Override
                            public void onSubscribe(Subscription s) {
                                s.request(Long.MAX_VALUE);
                            }

                            @Override
                            public void onNext(V value) {
                                this.currValue = value;
                                m.onNext(value);
                                if (forward) {
                                    currentIndex++;
                                } else {
                                    currentIndex--;
                                }
                            }

                            @Override
                            public void onError(Throwable error) {
                                m.onError(error);
                            }

                            @Override
                            public void onComplete() {
                                if (this.currValue == null) {
                                    m.onComplete();
                                    return;
                                }
                                if (n - 1L == 0L) {
                                    return;
                                }
                                this.onRequest(n - 1L);
                            }
                        });
                    }
                });
            }
        };
    }

    @Override
    public Publisher<Long> add(V e) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPUSH, this.getName(), e);
    }

    @Override
    public Publisher<Boolean> remove(Object o) {
        return this.reactive(this.instance.removeAsync(o));
    }

    protected Publisher<Boolean> remove(Object o, int count) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LREM_SINGLE, this.getName(), count, o);
    }

    @Override
    public Publisher<Boolean> containsAll(Collection<?> c) {
        return this.reactive(this.instance.containsAllAsync(c));
    }

    @Override
    public Publisher<Long> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(this){

            @Override
            public Long sum(Long first, Long second) {
                return second;
            }
        }.addAll(c);
    }

    @Override
    public Publisher<Long> addAll(Collection<? extends V> c) {
        if (c.isEmpty()) {
            return this.size();
        }
        ArrayList<String> args = new ArrayList<String>(c.size() + 1);
        args.add(this.getName());
        args.addAll(c);
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.RPUSH, args.toArray());
    }

    @Override
    public Publisher<Long> addAll(long index, Collection<? extends V> coll) {
        if (index < 0L) {
            throw new IndexOutOfBoundsException("index: " + index);
        }
        if (coll.isEmpty()) {
            return this.size();
        }
        if (index == 0L) {
            ArrayList<V> elements = new ArrayList<V>(coll);
            Collections.reverse(elements);
            elements.add(0, this.getName());
            return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LPUSH, elements.toArray());
        }
        ArrayList<Long> args = new ArrayList<Long>(coll.size() + 1);
        args.add(index);
        args.addAll(coll);
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand<Long>("EVAL", new LongReplayConvertor(), 5, RedisCommand.ValueType.OBJECTS), "local ind = table.remove(ARGV, 1); local size = redis.call('llen', KEYS[1]); assert(tonumber(ind) <= size, 'index: ' .. ind .. ' but current size: ' .. size); local tail = redis.call('lrange', KEYS[1], ind, -1); redis.call('ltrim', KEYS[1], 0, ind - 1); for i, v in ipairs(ARGV) do redis.call('rpush', KEYS[1], v) end;for i, v in ipairs(tail) do redis.call('rpush', KEYS[1], v) end;return redis.call('llen', KEYS[1]);", Collections.singletonList(this.getName()), args.toArray());
    }

    @Override
    public Publisher<Boolean> removeAll(Collection<?> c) {
        return this.reactive(this.instance.removeAllAsync(c));
    }

    @Override
    public Publisher<Boolean> retainAll(Collection<?> c) {
        return this.reactive(this.instance.retainAllAsync(c));
    }

    @Override
    public Publisher<V> get(long index) {
        return this.commandExecutor.readReactive(this.getName(), this.codec, RedisCommands.LINDEX, this.getName(), index);
    }

    @Override
    public Publisher<V> set(long index, V element) {
        return this.commandExecutor.evalWriteReactive(this.getName(), this.codec, new RedisCommand("EVAL", 5), "local v = redis.call('lindex', KEYS[1], ARGV[1]); redis.call('lset', KEYS[1], ARGV[1], ARGV[2]); return v", Collections.singletonList(this.getName()), index, element);
    }

    @Override
    public Publisher<Void> fastSet(long index, V element) {
        return this.commandExecutor.writeReactive(this.getName(), this.codec, RedisCommands.LSET, this.getName(), index, element);
    }

    @Override
    public Publisher<Long> add(long index, V element) {
        return this.addAll(index, Collections.singleton(element));
    }

    @Override
    public Publisher<V> remove(long index) {
        return this.reactive(this.instance.removeAsync(index));
    }

    @Override
    public Publisher<Boolean> contains(Object o) {
        return this.reactive(this.instance.containsAsync(o));
    }

    @Override
    public Publisher<Long> indexOf(Object o) {
        return this.reactive(this.instance.indexOfAsync(o, new LongReplayConvertor()));
    }

    @Override
    public Publisher<Long> lastIndexOf(Object o) {
        return this.reactive(this.instance.lastIndexOfAsync(o, new LongReplayConvertor()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RedissonListReactive)) {
            return false;
        }
        Stream<V> e1 = Streams.wrap(this.iterator());
        Stream<V> e2 = Streams.wrap(((RedissonListReactive)o).iterator());
        Long count = Streams.merge(e1, e2).groupBy(new Function<Object, Object>(){

            @Override
            public Object apply(Object t) {
                return t;
            }
        }).count().next().poll();
        boolean res = count.equals(Streams.wrap(this.size()).next().poll());
        return res &= count.equals(Streams.wrap(((RedissonListReactive)o).size()).next().poll());
    }

    public int hashCode() {
        Integer hash = Streams.wrap(this.iterator()).map(new Function<V, Integer>(){

            @Override
            public Integer apply(V t) {
                return t.hashCode();
            }
        }).reduce(1, new BiFunction<Integer, Integer, Integer>(){

            @Override
            public Integer apply(Integer t, Integer u) {
                return 31 * t + u;
            }
        }).next().poll();
        if (hash == null) {
            return 1;
        }
        return hash;
    }
}

