/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.misc.AbstractCacheMap;

public class LRUCacheMap<K, V>
extends AbstractCacheMap<K, V> {
    private final Queue<AbstractCacheMap.CachedValue> queue = new ConcurrentLinkedQueue<AbstractCacheMap.CachedValue>();

    public LRUCacheMap(int size, long timeToLiveInMillis, long maxIdleInMillis) {
        super(size, timeToLiveInMillis, maxIdleInMillis);
    }

    @Override
    protected void onValueCreate(AbstractCacheMap.CachedValue value) {
        this.queue.add(value);
    }

    @Override
    protected void onValueRemove(AbstractCacheMap.CachedValue value) {
        this.queue.remove(value);
    }

    @Override
    protected void onValueRead(AbstractCacheMap.CachedValue value) {
        if (this.queue.remove(value)) {
            this.queue.add(value);
        }
    }

    @Override
    protected void onMapFull() {
        AbstractCacheMap.CachedValue value = this.queue.poll();
        if (value != null) {
            this.map.remove(value.getKey(), value);
        }
    }

    @Override
    public void clear() {
        this.queue.clear();
        super.clear();
    }
}

