/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection.pool;

import java.util.concurrent.CompletableFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.pool.ConnectionPool;

public class MasterConnectionPool
extends ConnectionPool<RedisConnection> {
    public MasterConnectionPool(MasterSlaveServersConfig config, ConnectionManager connectionManager, MasterSlaveEntry masterSlaveEntry) {
        super(config, connectionManager, masterSlaveEntry);
    }

    @Override
    public CompletableFuture<RedisConnection> get(RedisCommand<?> command) {
        return this.acquireConnection(command, (ClientConnectionsEntry)this.entries.peek());
    }

    public void remove(ClientConnectionsEntry entry) {
        this.entries.remove(entry);
    }

    @Override
    protected int getMinimumIdleSize(ClientConnectionsEntry entry) {
        return this.config.getMasterConnectionMinimumIdleSize();
    }
}

