/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueEventLoopGroup;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.resolver.AddressResolver;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.DefaultAddressResolverGroup;
import io.netty.resolver.dns.DnsServerAddressStreamProviders;
import io.netty.util.HashedWheelTimer;
import io.netty.util.NetUtil;
import io.netty.util.Timeout;
import io.netty.util.Timer;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.redisson.ElementsSubscribeService;
import org.redisson.Version;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.RedisNodeNotFoundException;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.config.BaseConfig;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.TransportMode;
import org.redisson.connection.ConnectionEventsHub;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.DNSMonitor;
import org.redisson.connection.IdleConnectionWatcher;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.NodeSource;
import org.redisson.connection.SingleEntry;
import org.redisson.misc.InfinitySemaphoreLatch;
import org.redisson.misc.RedisURI;
import org.redisson.pubsub.PublishSubscribeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveConnectionManager
implements ConnectionManager {
    public static final Timeout DUMMY_TIMEOUT = new Timeout(){

        @Override
        public Timer timer() {
            return null;
        }

        @Override
        public TimerTask task() {
            return null;
        }

        @Override
        public boolean isExpired() {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean cancel() {
            return true;
        }
    };
    protected final String id;
    public static final int MAX_SLOT = 16384;
    protected final ClusterSlotRange singleSlotRange = new ClusterSlotRange(0, 16383);
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private HashedWheelTimer timer;
    protected Codec codec;
    protected final EventLoopGroup group;
    protected final Class<? extends SocketChannel> socketChannelClass;
    protected DNSMonitor dnsMonitor;
    protected MasterSlaveServersConfig config;
    private MasterSlaveEntry masterSlaveEntry;
    private final Promise<Void> shutdownPromise = ImmediateEventExecutor.INSTANCE.newPromise();
    private final InfinitySemaphoreLatch shutdownLatch = new InfinitySemaphoreLatch();
    private IdleConnectionWatcher connectionWatcher;
    private final ConnectionEventsHub connectionEventsHub = new ConnectionEventsHub();
    private final ExecutorService executor;
    private final Config cfg;
    protected final AddressResolverGroup<InetSocketAddress> resolverGroup;
    private final ElementsSubscribeService elementsSubscribeService = new ElementsSubscribeService(this);
    protected PublishSubscribeService subscribeService;
    private final Map<RedisURI, RedisConnection> nodeConnections = new ConcurrentHashMap<RedisURI, RedisConnection>();

    public MasterSlaveConnectionManager(MasterSlaveServersConfig cfg, Config config, UUID id) {
        this(config, id);
        this.config = cfg;
        if (cfg.getSlaveAddresses().isEmpty() && (cfg.getReadMode() == ReadMode.SLAVE || cfg.getReadMode() == ReadMode.MASTER_SLAVE)) {
            throw new IllegalArgumentException("Slaves aren't defined. readMode can't be SLAVE or MASTER_SLAVE");
        }
        this.initTimer(cfg);
        this.initSingleEntry();
    }

    protected MasterSlaveConnectionManager(Config cfg, UUID id) {
        this.id = id.toString();
        Version.logVersion();
        if (cfg.getTransportMode() == TransportMode.EPOLL) {
            this.group = cfg.getEventLoopGroup() == null ? new EpollEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = EpollSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(EpollDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        } else if (cfg.getTransportMode() == TransportMode.KQUEUE) {
            this.group = cfg.getEventLoopGroup() == null ? new KQueueEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = KQueueSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(KQueueDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        } else {
            this.group = cfg.getEventLoopGroup() == null ? new NioEventLoopGroup(cfg.getNettyThreads(), new DefaultThreadFactory("redisson-netty")) : cfg.getEventLoopGroup();
            this.socketChannelClass = NioSocketChannel.class;
            this.resolverGroup = PlatformDependent.isAndroid() ? DefaultAddressResolverGroup.INSTANCE : cfg.getAddressResolverGroupFactory().create(NioDatagramChannel.class, DnsServerAddressStreamProviders.platformDefault());
        }
        if (cfg.getExecutor() == null) {
            int threads = Runtime.getRuntime().availableProcessors() * 2;
            if (cfg.getThreads() != 0) {
                threads = cfg.getThreads();
            }
            this.executor = Executors.newFixedThreadPool(threads, new DefaultThreadFactory("redisson"));
        } else {
            this.executor = cfg.getExecutor();
        }
        this.cfg = cfg;
        this.codec = cfg.getCodec();
        if (cfg.getConnectionListener() != null) {
            this.connectionEventsHub.addListener(cfg.getConnectionListener());
        }
    }

    protected void closeNodeConnections() {
        this.nodeConnections.values().stream().map(c -> c.getRedisClient().shutdownAsync()).forEach(f -> f.toCompletableFuture().join());
    }

    protected void closeNodeConnection(RedisConnection conn) {
        if (this.nodeConnections.values().removeAll(Arrays.asList(conn))) {
            conn.closeAsync();
        }
    }

    protected final void disconnectNode(RedisURI addr) {
        RedisConnection conn = this.nodeConnections.remove(addr);
        if (conn != null) {
            this.nodeConnections.values().removeAll(Arrays.asList(conn));
            conn.closeAsync();
        }
    }

    protected final CompletionStage<RedisConnection> connectToNode(BaseConfig<?> cfg, RedisURI addr, String sslHostname) {
        return this.connectToNode(NodeType.MASTER, cfg, addr, sslHostname);
    }

    protected final CompletionStage<RedisConnection> connectToNode(NodeType type, BaseConfig<?> cfg, RedisURI addr, String sslHostname) {
        RedisConnection conn = this.nodeConnections.get(addr);
        if (conn != null) {
            if (!conn.isActive()) {
                this.closeNodeConnection(conn);
            } else {
                return CompletableFuture.completedFuture(conn);
            }
        }
        RedisClient client = this.createClient(type, addr, cfg.getConnectTimeout(), cfg.getTimeout(), sslHostname);
        RFuture<RedisConnection> future = client.connectAsync();
        return future.thenCompose(connection -> {
            if (connection.isActive()) {
                if (!addr.isIP()) {
                    RedisURI address = new RedisURI(addr.getScheme() + "://" + connection.getRedisClient().getAddr().getAddress().getHostAddress() + ":" + connection.getRedisClient().getAddr().getPort());
                    this.nodeConnections.put(address, (RedisConnection)connection);
                }
                this.nodeConnections.put(addr, (RedisConnection)connection);
                return CompletableFuture.completedFuture(connection);
            }
            connection.closeAsync();
            CompletableFuture f = new CompletableFuture();
            f.completeExceptionally(new RedisException("Connection to " + connection.getRedisClient().getAddr() + " is not active!"));
            return f;
        });
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean isClusterMode() {
        return false;
    }

    @Override
    public IdleConnectionWatcher getConnectionWatcher() {
        return this.connectionWatcher;
    }

    @Override
    public Config getCfg() {
        return this.cfg;
    }

    @Override
    public MasterSlaveServersConfig getConfig() {
        return this.config;
    }

    @Override
    public Codec getCodec() {
        return this.codec;
    }

    @Override
    public Collection<MasterSlaveEntry> getEntrySet() {
        if (this.masterSlaveEntry != null) {
            return Collections.singletonList(this.masterSlaveEntry);
        }
        return Collections.emptyList();
    }

    protected void initTimer(MasterSlaveServersConfig config) {
        int[] timeouts = new int[]{config.getRetryInterval(), config.getTimeout()};
        Arrays.sort(timeouts);
        int minTimeout = timeouts[0];
        minTimeout = minTimeout % 100 != 0 ? minTimeout % 100 / 2 : (minTimeout == 100 ? 50 : 100);
        this.timer = new HashedWheelTimer(new DefaultThreadFactory("redisson-timer"), minTimeout, TimeUnit.MILLISECONDS, 1024, false);
        this.connectionWatcher = new IdleConnectionWatcher(this, config);
        this.subscribeService = new PublishSubscribeService(this, config);
    }

    protected void initSingleEntry() {
        try {
            this.masterSlaveEntry = this.config.checkSkipSlavesInit() ? new SingleEntry(this, this.config) : new MasterSlaveEntry(this, this.config);
            CompletableFuture<RedisClient> masterFuture = this.masterSlaveEntry.setupMasterEntry(new RedisURI(this.config.getMasterAddress()));
            masterFuture.join();
            if (!this.config.checkSkipSlavesInit()) {
                CompletableFuture<Void> fs = this.masterSlaveEntry.initSlaveBalancer(this.getDisconnectedNodes());
                fs.join();
            }
            this.startDNSMonitoring(masterFuture.getNow(null));
        }
        catch (Exception e) {
            this.stopThreads();
            if (e instanceof CompletionException) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RedisConnectionException(e.getCause());
            }
            throw e;
        }
    }

    protected void startDNSMonitoring(RedisClient masterHost) {
        if (masterHost.getConfig().getAddress().isIP()) {
            return;
        }
        if (this.config.getDnsMonitoringInterval() != -1L) {
            Set<RedisURI> slaveAddresses = this.config.getSlaveAddresses().stream().map(r -> new RedisURI((String)r)).collect(Collectors.toSet());
            this.dnsMonitor = new DNSMonitor(this, masterHost, slaveAddresses, this.config.getDnsMonitoringInterval(), this.resolverGroup);
            this.dnsMonitor.start();
        }
    }

    protected Collection<RedisURI> getDisconnectedNodes() {
        return Collections.emptySet();
    }

    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig c = new MasterSlaveServersConfig();
        c.setPingConnectionInterval(cfg.getPingConnectionInterval());
        c.setSslEnableEndpointIdentification(cfg.isSslEnableEndpointIdentification());
        c.setSslProvider(cfg.getSslProvider());
        c.setSslTruststore(cfg.getSslTruststore());
        c.setSslTruststorePassword(cfg.getSslTruststorePassword());
        c.setSslKeystore(cfg.getSslKeystore());
        c.setSslKeystorePassword(cfg.getSslKeystorePassword());
        c.setSslProtocols(cfg.getSslProtocols());
        c.setRetryInterval(cfg.getRetryInterval());
        c.setRetryAttempts(cfg.getRetryAttempts());
        c.setTimeout(cfg.getTimeout());
        c.setLoadBalancer(cfg.getLoadBalancer());
        c.setPassword(cfg.getPassword());
        c.setUsername(cfg.getUsername());
        c.setClientName(cfg.getClientName());
        c.setMasterConnectionPoolSize(cfg.getMasterConnectionPoolSize());
        c.setSlaveConnectionPoolSize(cfg.getSlaveConnectionPoolSize());
        c.setSubscriptionConnectionPoolSize(cfg.getSubscriptionConnectionPoolSize());
        c.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        c.setConnectTimeout(cfg.getConnectTimeout());
        c.setIdleConnectionTimeout(cfg.getIdleConnectionTimeout());
        c.setFailedSlaveCheckInterval(cfg.getFailedSlaveCheckInterval());
        c.setFailedSlaveReconnectionInterval(cfg.getFailedSlaveReconnectionInterval());
        c.setMasterConnectionMinimumIdleSize(cfg.getMasterConnectionMinimumIdleSize());
        c.setSlaveConnectionMinimumIdleSize(cfg.getSlaveConnectionMinimumIdleSize());
        c.setSubscriptionConnectionMinimumIdleSize(cfg.getSubscriptionConnectionMinimumIdleSize());
        c.setReadMode(cfg.getReadMode());
        c.setSubscriptionMode(cfg.getSubscriptionMode());
        c.setDnsMonitoringInterval(cfg.getDnsMonitoringInterval());
        c.setKeepAlive(cfg.isKeepAlive());
        c.setTcpNoDelay(cfg.isTcpNoDelay());
        c.setNameMapper(cfg.getNameMapper());
        c.setCredentialsResolver(cfg.getCredentialsResolver());
        return c;
    }

    @Override
    public RedisClient createClient(NodeType type, RedisURI address, String sslHostname) {
        RedisClient client = this.createClient(type, address, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    @Override
    public RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, String sslHostname) {
        RedisClient client = this.createClient(type, address, uri, this.config.getConnectTimeout(), this.config.getTimeout(), sslHostname);
        return client;
    }

    @Override
    public RedisClient createClient(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, address, timeout, commandTimeout, sslHostname);
        return RedisClient.create(redisConfig);
    }

    private RedisClient createClient(NodeType type, InetSocketAddress address, RedisURI uri, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = this.createRedisConfig(type, null, timeout, commandTimeout, sslHostname);
        redisConfig.setAddress(address, uri);
        return RedisClient.create(redisConfig);
    }

    protected RedisClientConfig createRedisConfig(NodeType type, RedisURI address, int timeout, int commandTimeout, String sslHostname) {
        RedisClientConfig redisConfig = new RedisClientConfig();
        redisConfig.setAddress(address).setTimer(this.timer).setExecutor(this.executor).setResolverGroup(this.resolverGroup).setGroup(this.group).setSocketChannelClass(this.socketChannelClass).setConnectTimeout(timeout).setCommandTimeout(commandTimeout).setSslHostname(sslHostname).setSslEnableEndpointIdentification(this.config.isSslEnableEndpointIdentification()).setSslProvider(this.config.getSslProvider()).setSslTruststore(this.config.getSslTruststore()).setSslTruststorePassword(this.config.getSslTruststorePassword()).setSslKeystore(this.config.getSslKeystore()).setSslKeystorePassword(this.config.getSslKeystorePassword()).setSslProtocols(this.config.getSslProtocols()).setClientName(this.config.getClientName()).setKeepPubSubOrder(this.cfg.isKeepPubSubOrder()).setPingConnectionInterval(this.config.getPingConnectionInterval()).setKeepAlive(this.config.isKeepAlive()).setTcpNoDelay(this.config.isTcpNoDelay()).setUsername(this.config.getUsername()).setPassword(this.config.getPassword()).setNettyHook(this.cfg.getNettyHook()).setCredentialsResolver(this.config.getCredentialsResolver());
        if (type != NodeType.SENTINEL) {
            redisConfig.setDatabase(this.config.getDatabase());
        }
        return redisConfig;
    }

    @Override
    public int calcSlot(String key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public int calcSlot(byte[] key) {
        return this.singleSlotRange.getStartSlot();
    }

    @Override
    public MasterSlaveEntry getEntry(InetSocketAddress address) {
        return this.masterSlaveEntry;
    }

    protected MasterSlaveEntry getEntry(RedisURI addr) {
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getEntry(RedisClient redisClient) {
        return this.masterSlaveEntry;
    }

    @Override
    public MasterSlaveEntry getEntry(String name) {
        int slot = this.calcSlot(name);
        return this.getEntry(slot);
    }

    @Override
    public MasterSlaveEntry getEntry(int slot) {
        return this.masterSlaveEntry;
    }

    protected CompletableFuture<RedisClient> changeMaster(int slot, RedisURI address) {
        MasterSlaveEntry entry = this.getEntry(slot);
        return entry.changeMaster(address);
    }

    @Override
    public CompletableFuture<RedisConnection> connectionWriteOp(NodeSource source, RedisCommand<?> command) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.createNodeNotFoundException(source));
            return f;
        }
        if (source.getRedirect() != null && !source.getAddr().equals(entry.getClient().getAddr()) && entry.hasSlave(source.getAddr())) {
            return entry.redirectedConnectionWriteOp(command, source.getAddr());
        }
        return entry.connectionWriteOp(command);
    }

    private MasterSlaveEntry getEntry(NodeSource source) {
        if (source.getRedirect() != null) {
            return this.getEntry(source.getAddr());
        }
        MasterSlaveEntry entry = source.getEntry();
        if (source.getRedisClient() != null) {
            entry = this.getEntry(source.getRedisClient());
        }
        if (entry == null && source.getSlot() != null) {
            entry = this.getEntry(source.getSlot());
        }
        return entry;
    }

    @Override
    public CompletableFuture<RedisConnection> connectionReadOp(NodeSource source, RedisCommand<?> command) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            CompletableFuture<RedisConnection> f = new CompletableFuture<RedisConnection>();
            f.completeExceptionally(this.createNodeNotFoundException(source));
            return f;
        }
        if (source.getRedirect() != null) {
            return entry.connectionReadOp(command, source.getAddr());
        }
        if (source.getRedisClient() != null) {
            return entry.connectionReadOp(command, source.getRedisClient());
        }
        return entry.connectionReadOp(command);
    }

    @Override
    public RedisNodeNotFoundException createNodeNotFoundException(NodeSource source) {
        RedisNodeNotFoundException ex = source.getSlot() != null && source.getAddr() == null && source.getRedisClient() == null ? new RedisNodeNotFoundException("Node for slot: " + source.getSlot() + " hasn't been discovered yet. Check cluster slots coverage using CLUSTER NODES command. Increase value of retryAttempts and/or retryInterval settings.") : new RedisNodeNotFoundException("Node: " + source + " hasn't been discovered yet. Increase value of retryAttempts and/or retryInterval settings.");
        return ex;
    }

    @Override
    public void releaseWrite(NodeSource source, RedisConnection connection) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            this.log.error("Node: {} can't be found", (Object)source);
        } else {
            entry.releaseWrite(connection);
        }
    }

    @Override
    public void releaseRead(NodeSource source, RedisConnection connection) {
        MasterSlaveEntry entry = this.getEntry(source);
        if (entry == null) {
            this.log.error("Node: {} can't be found", (Object)source);
        } else {
            entry.releaseRead(connection);
        }
    }

    @Override
    public void shutdown() {
        this.shutdown(0L, 2L, TimeUnit.SECONDS);
    }

    @Override
    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        if (this.dnsMonitor != null) {
            this.dnsMonitor.stop();
        }
        this.connectionWatcher.stop();
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        for (MasterSlaveEntry entry : this.getEntrySet()) {
            futures.add(entry.shutdownAsync());
        }
        CompletableFuture<Void> future = CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
        try {
            future.get(timeout, unit);
        }
        catch (Exception entry) {
            // empty catch block
        }
        this.resolverGroup.close();
        this.shutdownLatch.close();
        if (this.cfg.getExecutor() == null) {
            this.executor.shutdown();
            try {
                this.executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.shutdownPromise.trySuccess(null);
        this.shutdownLatch.awaitUninterruptibly();
        if (this.cfg.getEventLoopGroup() == null) {
            this.group.shutdownGracefully(quietPeriod, timeout, unit).syncUninterruptibly();
        }
        this.timer.stop();
    }

    @Override
    public boolean isShuttingDown() {
        return this.shutdownLatch.isClosed();
    }

    @Override
    public boolean isShutdown() {
        return this.group.isTerminated();
    }

    @Override
    public EventLoopGroup getGroup() {
        return this.group;
    }

    @Override
    public Timeout newTimeout(TimerTask task, long delay, TimeUnit unit) {
        try {
            return this.timer.newTimeout(task, delay, unit);
        }
        catch (IllegalStateException e) {
            if (this.isShuttingDown()) {
                return DUMMY_TIMEOUT;
            }
            throw e;
        }
    }

    @Override
    public InfinitySemaphoreLatch getShutdownLatch() {
        return this.shutdownLatch;
    }

    @Override
    public Future<Void> getShutdownPromise() {
        return this.shutdownPromise;
    }

    @Override
    public ConnectionEventsHub getConnectionEventsHub() {
        return this.connectionEventsHub;
    }

    protected void stopThreads() {
        this.shutdown();
    }

    @Override
    public PublishSubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    @Override
    public ElementsSubscribeService getElementsSubscribeService() {
        return this.elementsSubscribeService;
    }

    @Override
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Override
    public RedisURI getLastClusterNode() {
        return null;
    }

    @Override
    public RedisURI applyNatMap(RedisURI address) {
        return address;
    }

    @Override
    public CompletableFuture<RedisURI> resolveIP(RedisURI address) {
        return this.resolveIP(address.getScheme(), address);
    }

    protected CompletableFuture<RedisURI> resolveIP(String scheme, RedisURI address) {
        if (address.isIP()) {
            RedisURI addr = this.toURI(scheme, address.getHost(), "" + address.getPort());
            return CompletableFuture.completedFuture(addr);
        }
        CompletableFuture<RedisURI> result = new CompletableFuture<RedisURI>();
        AddressResolver<InetSocketAddress> resolver = this.resolverGroup.getResolver(this.getGroup().next());
        InetSocketAddress addr = InetSocketAddress.createUnresolved(address.getHost(), address.getPort());
        Future<InetSocketAddress> future = resolver.resolve(addr);
        future.addListener(f -> {
            if (!f.isSuccess()) {
                this.log.error("Unable to resolve {}", (Object)address, (Object)f.cause());
                result.completeExceptionally(f.cause());
                return;
            }
            InetSocketAddress s = (InetSocketAddress)f.getNow();
            RedisURI uri = this.toURI(scheme, s.getAddress().getHostAddress(), "" + address.getPort());
            result.complete(uri);
        });
        return result;
    }

    protected RedisURI toURI(String scheme, String host, String port) {
        if (NetUtil.isValidIpV6Address(host)) {
            byte[] addr = NetUtil.createByteArrayFromIpAddressString(host);
            try {
                InetAddress ia = InetAddress.getByAddress(host, addr);
                host = ia.getHostAddress();
            }
            catch (UnknownHostException e) {
                throw new RuntimeException(e);
            }
        }
        RedisURI uri = new RedisURI(scheme + "://" + host + ":" + port);
        return this.applyNatMap(uri);
    }
}

