/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBufUtil;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.api.WorkerOptions;
import org.redisson.client.RedisConnection;
import org.redisson.config.Config;
import org.redisson.config.RedissonNodeConfig;
import org.redisson.config.RedissonNodeFileConfig;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RedissonNode {
    private static final Logger log = LoggerFactory.getLogger(RedissonNode.class);
    private boolean hasRedissonInstance;
    private RedissonClient redisson;
    private final RedissonNodeConfig config;
    private final String id;
    private InetSocketAddress remoteAddress;
    private InetSocketAddress localAddress;

    private RedissonNode(RedissonNodeConfig config, RedissonClient redisson) {
        this.config = new RedissonNodeConfig(config);
        this.id = this.generateId();
        this.redisson = redisson;
        this.hasRedissonInstance = redisson == null;
    }

    public RedissonClient getRedisson() {
        return this.redisson;
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public String getId() {
        return this.id;
    }

    private String generateId() {
        byte[] id = new byte[8];
        ThreadLocalRandom.current().nextBytes(id);
        return ByteBufUtil.hexDump(id);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            throw new IllegalArgumentException("Config file not defined");
        }
        String configPath = args[0];
        RedissonNodeFileConfig config = null;
        try {
            config = RedissonNodeFileConfig.fromJSON(new File(configPath));
        }
        catch (IOException e) {
            try {
                config = RedissonNodeFileConfig.fromYAML(new File(configPath));
            }
            catch (IOException e1) {
                log.error("Can't parse json config {}", (Object)configPath, (Object)e);
                throw new IllegalArgumentException("Can't parse yaml config " + configPath, e1);
            }
        }
        final RedissonNode node = RedissonNode.create(config);
        node.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                node.shutdown();
            }
        });
    }

    public void shutdown() {
        if (this.hasRedissonInstance) {
            this.redisson.shutdown(0L, 15L, TimeUnit.MINUTES);
            log.info("Redisson node has been shutdown successfully");
        }
    }

    public void start() {
        int mapReduceWorkers;
        if (this.hasRedissonInstance) {
            this.redisson = Redisson.create(this.config);
        }
        this.retrieveAddresses();
        if (this.config.getRedissonNodeInitializer() != null) {
            this.config.getRedissonNodeInitializer().onStartup(this);
        }
        if ((mapReduceWorkers = this.config.getMapReduceWorkers()) != -1) {
            if (mapReduceWorkers == 0) {
                mapReduceWorkers = Runtime.getRuntime().availableProcessors();
            }
            WorkerOptions options = WorkerOptions.defaults().workers(mapReduceWorkers).beanFactory(this.config.getBeanFactory());
            this.redisson.getExecutorService("redisson_mapreduce").registerWorkers(options);
            log.info("{} map reduce worker(s) registered", (Object)mapReduceWorkers);
        }
        for (Map.Entry<String, Integer> entry : this.config.getExecutorServiceWorkers().entrySet()) {
            String name = entry.getKey();
            int workers = entry.getValue();
            WorkerOptions options = WorkerOptions.defaults().workers(workers).beanFactory(this.config.getBeanFactory());
            this.redisson.getExecutorService(name).registerWorkers(options);
            log.info("{} worker(s) registered for ExecutorService with '{}' name", (Object)workers, (Object)name);
        }
        log.info("Redisson node started!");
    }

    private void retrieveAddresses() {
        ConnectionManager connectionManager = ((Redisson)this.redisson).getConnectionManager();
        for (MasterSlaveEntry entry : connectionManager.getEntrySet()) {
            CompletableFuture<RedisConnection> readFuture = entry.connectionReadOp(null);
            RedisConnection readConnection = null;
            try {
                readConnection = (RedisConnection)readFuture.toCompletableFuture().get(connectionManager.getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (readConnection != null) {
                entry.releaseRead(readConnection);
                this.remoteAddress = (InetSocketAddress)readConnection.getChannel().remoteAddress();
                this.localAddress = (InetSocketAddress)readConnection.getChannel().localAddress();
                return;
            }
            CompletableFuture<RedisConnection> writeFuture = entry.connectionWriteOp(null);
            RedisConnection writeConnection = null;
            try {
                writeConnection = (RedisConnection)writeFuture.toCompletableFuture().get(connectionManager.getConfig().getConnectTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (writeConnection == null) continue;
            entry.releaseWrite(writeConnection);
            this.remoteAddress = (InetSocketAddress)writeConnection.getChannel().remoteAddress();
            this.localAddress = (InetSocketAddress)writeConnection.getChannel().localAddress();
            return;
        }
    }

    public static RedissonNode create(RedissonNodeConfig config) {
        return RedissonNode.create(config, null);
    }

    public static RedissonNode create(RedissonNodeFileConfig config) {
        return RedissonNode.create(new RedissonNodeConfig((Config)config), null);
    }

    public static RedissonNode create(RedissonNodeConfig config, RedissonClient redisson) {
        return new RedissonNode(config, redisson);
    }
}

