/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.redisnode;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.stream.IntStream;
import org.redisson.api.NodeType;
import org.redisson.api.RFuture;
import org.redisson.api.redisnode.RedisClusterMaster;
import org.redisson.api.redisnode.RedisClusterMasterAsync;
import org.redisson.api.redisnode.RedisClusterSlave;
import org.redisson.api.redisnode.RedisClusterSlaveAsync;
import org.redisson.api.redisnode.RedisMaster;
import org.redisson.api.redisnode.RedisMasterAsync;
import org.redisson.api.redisnode.RedisNode;
import org.redisson.api.redisnode.RedisSlave;
import org.redisson.api.redisnode.RedisSlaveAsync;
import org.redisson.api.redisnode.SetSlotCommand;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.Time;
import org.redisson.cluster.ClusterSlotRange;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.RedisURI;

public class RedisNode
implements RedisClusterMaster,
RedisClusterSlave,
RedisMaster,
RedisSlave,
RedisClusterMasterAsync,
RedisClusterSlaveAsync,
RedisMasterAsync,
RedisSlaveAsync {
    final RedisClient client;
    final CommandAsyncExecutor commandExecutor;
    private final NodeType type;

    public RedisNode(RedisClient client, CommandAsyncExecutor commandExecutor, NodeType type) {
        this.client = client;
        this.commandExecutor = commandExecutor;
        this.type = type;
    }

    public RedisClient getClient() {
        return this.client;
    }

    @Override
    public InetSocketAddress getAddr() {
        return this.client.getAddr();
    }

    @Override
    public RFuture<Boolean> pingAsync() {
        return this.pingAsync(1L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<Boolean> pingAsync(long timeout, TimeUnit timeUnit) {
        RFuture f = this.commandExecutor.readAsync(this.client, null, RedisCommands.PING_BOOL, new Object[0]);
        CompletionStage<Boolean> s = f.exceptionally(e -> false);
        this.commandExecutor.getConnectionManager().newTimeout(t -> {
            RedisTimeoutException ex = new RedisTimeoutException("Command execution timeout (" + timeUnit.toMillis(timeout) + "ms) for command: PING, Redis client: " + this.client);
            s.toCompletableFuture().completeExceptionally(ex);
        }, timeout, timeUnit);
        return new CompletableFutureWrapper<Boolean>(s);
    }

    @Override
    public boolean ping() {
        return this.commandExecutor.get(this.pingAsync());
    }

    @Override
    public boolean ping(long timeout, TimeUnit timeUnit) {
        return this.commandExecutor.get(this.pingAsync(timeout, timeUnit));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getAddr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RedisNode other = (RedisNode)obj;
        return !(this.client == null ? other.client != null : !this.client.getAddr().equals(other.client.getAddr()));
    }

    @Override
    public RFuture<Time> timeAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)LongCodec.INSTANCE, RedisCommands.TIME, new Object[0]);
    }

    @Override
    public Time time() {
        return this.commandExecutor.get(this.timeAsync());
    }

    public String toString() {
        return "RedisClientEntry [client=" + this.client + ", type=" + (Object)((Object)this.type) + "]";
    }

    @Override
    public RFuture<Map<String, String>> clusterInfoAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_INFO, new Object[0]);
    }

    @Override
    public Map<String, String> clusterInfo() {
        return this.commandExecutor.get(this.clusterInfoAsync());
    }

    @Override
    public String clusterId() {
        return this.commandExecutor.get(this.clusterIdAsync());
    }

    @Override
    public void clusterAddSlots(int ... slots) {
        this.commandExecutor.get(this.clusterAddSlotsAsync(slots));
    }

    @Override
    public void clusterReplicate(String nodeId) {
        this.commandExecutor.get(this.clusterReplicateAsync(nodeId));
    }

    @Override
    public void clusterForget(String nodeId) {
        this.commandExecutor.get(this.clusterForgetAsync(nodeId));
    }

    @Override
    public void clusterDeleteSlots(int ... slots) {
        this.commandExecutor.get(this.clusterDeleteSlotsAsync(slots));
    }

    @Override
    public long clusterCountKeysInSlot(int slot) {
        return this.commandExecutor.get(this.clusterCountKeysInSlotAsync(slot));
    }

    @Override
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        return this.commandExecutor.get(this.clusterGetKeysInSlotAsync(slot, count));
    }

    @Override
    public void clusterSetSlot(int slot, SetSlotCommand command) {
        this.commandExecutor.get(this.clusterSetSlotAsync(slot, command));
    }

    @Override
    public void clusterSetSlot(int slot, SetSlotCommand command, String nodeId) {
        this.commandExecutor.get(this.clusterSetSlotAsync(slot, command, nodeId));
    }

    @Override
    public void clusterMeet(String address) {
        this.commandExecutor.get(this.clusterMeetAsync(address));
    }

    @Override
    public long clusterCountFailureReports(String nodeId) {
        return this.commandExecutor.get(this.clusterCountFailureReportsAsync(nodeId));
    }

    @Override
    public void clusterFlushSlots() {
        this.commandExecutor.get(this.clusterFlushSlotsAsync());
    }

    @Override
    public Map<ClusterSlotRange, Set<String>> clusterSlots() {
        return this.commandExecutor.get(this.clusterSlotsAsync());
    }

    @Override
    public Map<String, String> info(RedisNode.InfoSection section) {
        return this.commandExecutor.get(this.infoAsync(section));
    }

    @Override
    public Map<String, String> getMemoryStatistics() {
        return this.commandExecutor.get(this.getMemoryStatisticsAsync());
    }

    @Override
    public RFuture<Map<String, String>> getMemoryStatisticsAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.MEMORY_STATS, new Object[0]);
    }

    @Override
    public RFuture<String> clusterIdAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_MYID, new Object[0]);
    }

    @Override
    public RFuture<Void> clusterAddSlotsAsync(int ... slots) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_ADDSLOTS, IntStream.of(slots).boxed().toArray());
    }

    @Override
    public RFuture<Void> clusterReplicateAsync(String nodeId) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_REPLICATE, nodeId);
    }

    @Override
    public RFuture<Void> clusterForgetAsync(String nodeId) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_FORGET, nodeId);
    }

    @Override
    public RFuture<Void> clusterDeleteSlotsAsync(int ... slots) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_DELSLOTS, IntStream.of(slots).boxed().toArray());
    }

    @Override
    public RFuture<Long> clusterCountKeysInSlotAsync(int slot) {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_COUNTKEYSINSLOT, slot);
    }

    @Override
    public RFuture<List<String>> clusterGetKeysInSlotAsync(int slot, int count) {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_GETKEYSINSLOT, slot, count);
    }

    @Override
    public RFuture<Void> clusterSetSlotAsync(int slot, SetSlotCommand command) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, command});
    }

    @Override
    public RFuture<Void> clusterSetSlotAsync(int slot, SetSlotCommand command, String nodeId) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_SETSLOT, new Object[]{slot, command, nodeId});
    }

    @Override
    public RFuture<Void> clusterMeetAsync(String address) {
        RedisURI uri = new RedisURI(address);
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_MEET, uri.getHost(), uri.getPort());
    }

    @Override
    public RFuture<Long> clusterCountFailureReportsAsync(String nodeId) {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_COUNTFAILUREREPORTS, nodeId);
    }

    @Override
    public RFuture<Void> clusterFlushSlotsAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_FLUSHSLOTS, new Object[0]);
    }

    @Override
    public RFuture<Map<ClusterSlotRange, Set<String>>> clusterSlotsAsync() {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CLUSTER_SLOTS, new Object[0]);
    }

    @Override
    public RFuture<Map<String, String>> infoAsync(RedisNode.InfoSection section) {
        if (section == RedisNode.InfoSection.ALL) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_ALL, new Object[0]);
        }
        if (section == RedisNode.InfoSection.DEFAULT) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_DEFAULT, new Object[0]);
        }
        if (section == RedisNode.InfoSection.SERVER) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_SERVER, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CLIENTS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CLIENTS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.MEMORY) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_MEMORY, new Object[0]);
        }
        if (section == RedisNode.InfoSection.PERSISTENCE) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_PERSISTENCE, new Object[0]);
        }
        if (section == RedisNode.InfoSection.STATS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_STATS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.REPLICATION) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_REPLICATION, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CPU) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CPU, new Object[0]);
        }
        if (section == RedisNode.InfoSection.COMMANDSTATS) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_COMMANDSTATS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CLUSTER) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_CLUSTER, new Object[0]);
        }
        if (section == RedisNode.InfoSection.KEYSPACE) {
            return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.INFO_KEYSPACE, new Object[0]);
        }
        throw new IllegalStateException();
    }

    @Override
    public Map<String, String> getConfig(String parameter) {
        return this.commandExecutor.get(this.getConfigAsync(parameter));
    }

    @Override
    public void setConfig(String parameter, String value) {
        this.commandExecutor.get(this.setConfigAsync(parameter, value));
    }

    @Override
    public RFuture<Map<String, String>> getConfigAsync(String parameter) {
        return this.commandExecutor.readAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CONFIG_GET_MAP, parameter);
    }

    @Override
    public RFuture<Void> setConfigAsync(String parameter, String value) {
        return this.commandExecutor.writeAsync(this.client, (Codec)StringCodec.INSTANCE, RedisCommands.CONFIG_SET, parameter, value);
    }
}

