/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.codec;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class KryoCodec
extends BaseCodec {
    private final Queue<Kryo> objects = new ConcurrentLinkedQueue<Kryo>();
    private final List<Class<?>> classes;
    private final ClassLoader classLoader;
    private final Decoder<Object> decoder = new Decoder<Object>(){

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Kryo kryo = null;
            try {
                kryo = KryoCodec.this.get();
                Object object = kryo.readClassAndObject(new Input((InputStream)new ByteBufInputStream(buf)));
                return object;
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RedissonKryoCodecException((Throwable)e);
            }
            finally {
                if (kryo != null) {
                    KryoCodec.this.offer(kryo);
                }
            }
        }
    };
    private final Encoder encoder = new Encoder(){

        @Override
        public ByteBuf encode(Object in) throws IOException {
            Kryo kryo = null;
            ByteBuf out = ByteBufAllocator.DEFAULT.buffer();
            try {
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                Output output = new Output((OutputStream)baos);
                kryo = KryoCodec.this.get();
                kryo.writeClassAndObject(output, in);
                output.close();
                ByteBuf byteBuf = baos.buffer();
                if (kryo != null) {
                    KryoCodec.this.offer(kryo);
                }
                return byteBuf;
            }
            catch (Exception e) {
                try {
                    out.release();
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new RedissonKryoCodecException((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (kryo != null) {
                        KryoCodec.this.offer(kryo);
                    }
                    throw throwable;
                }
            }
        }
    };

    public KryoCodec() {
        this(Collections.emptyList());
    }

    public KryoCodec(ClassLoader classLoader) {
        this(Collections.emptyList(), classLoader);
    }

    public KryoCodec(ClassLoader classLoader, KryoCodec codec) {
        this(codec.classes, classLoader);
    }

    public KryoCodec(List<Class<?>> classes) {
        this(classes, null);
    }

    public KryoCodec(List<Class<?>> classes, ClassLoader classLoader) {
        this.classes = classes;
        this.classLoader = classLoader;
    }

    public Kryo get() {
        Kryo kryo = this.objects.poll();
        if (kryo == null) {
            kryo = this.createInstance(this.classes, this.classLoader);
        }
        return kryo;
    }

    public void offer(Kryo kryo) {
        this.objects.offer(kryo);
    }

    protected Kryo createInstance(List<Class<?>> classes, ClassLoader classLoader) {
        Kryo kryo = new Kryo();
        if (classLoader != null) {
            kryo.setClassLoader(classLoader);
        }
        kryo.setReferences(false);
        for (Class<?> clazz : classes) {
            kryo.register(clazz);
        }
        return kryo;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.classLoader != null) {
            return this.classLoader;
        }
        return super.getClassLoader();
    }

    public class RedissonKryoCodecException
    extends RuntimeException {
        private static final long serialVersionUID = 9172336149805414947L;

        public RedissonKryoCodecException(Throwable cause) {
            super(cause.getMessage(), cause);
            this.setStackTrace(cause.getStackTrace());
        }
    }
}

