/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisClientConfig;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisLoadingException;
import org.redisson.client.protocol.RedisCommands;

public abstract class BaseConnectionHandler<C extends RedisConnection>
extends ChannelInboundHandlerAdapter {
    final RedisClient redisClient;
    final CompletableFuture<C> connectionPromise = new CompletableFuture();
    C connection;

    public BaseConnectionHandler(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.connection == null) {
            this.connection = this.createConnection(ctx);
        }
        super.channelRegistered(ctx);
    }

    abstract C createConnection(ChannelHandlerContext var1);

    @Override
    public void channelActive(ChannelHandlerContext ctx) {
        RFuture future;
        ArrayList futures = new ArrayList();
        RedisClientConfig config = this.redisClient.getConfig();
        String password = Objects.toString(config.getAddress().getPassword(), config.getPassword());
        if (password != null) {
            String username = Objects.toString(config.getAddress().getUsername(), config.getUsername());
            future = username != null ? ((RedisConnection)this.connection).async(RedisCommands.AUTH, username, password) : ((RedisConnection)this.connection).async(RedisCommands.AUTH, password);
            futures.add(future);
        }
        if (config.getDatabase() != 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.SELECT, config.getDatabase());
            futures.add(future);
        }
        if (config.getClientName() != null) {
            future = ((RedisConnection)this.connection).async(RedisCommands.CLIENT_SETNAME, config.getClientName());
            futures.add(future);
        }
        if (config.isReadOnly()) {
            future = ((RedisConnection)this.connection).async(RedisCommands.READONLY, new Object[0]);
            futures.add(future);
        }
        if (config.getPingConnectionInterval() > 0) {
            future = ((RedisConnection)this.connection).async(RedisCommands.PING, new Object[0]);
            futures.add(future);
        }
        if (futures.isEmpty()) {
            ctx.fireChannelActive();
            this.connectionPromise.complete(this.connection);
            return;
        }
        AtomicBoolean retry = new AtomicBoolean();
        AtomicInteger commandsCounter = new AtomicInteger(futures.size());
        for (RFuture rFuture : futures) {
            rFuture.whenComplete((res, e) -> {
                if (e != null) {
                    if (e instanceof RedisLoadingException) {
                        if (retry.compareAndSet(false, true)) {
                            ctx.executor().schedule(() -> this.channelActive(ctx), 1L, TimeUnit.SECONDS);
                        }
                        return;
                    }
                    ((RedisConnection)this.connection).closeAsync();
                    this.connectionPromise.completeExceptionally((Throwable)e);
                    return;
                }
                if (commandsCounter.decrementAndGet() == 0) {
                    ctx.fireChannelActive();
                    this.connectionPromise.complete(this.connection);
                }
            });
        }
    }
}

