/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubStatusListener;
import org.redisson.api.NameMapper;
import org.redisson.api.RFuture;
import org.redisson.api.RTopic;
import org.redisson.api.listener.MessageListener;
import org.redisson.api.listener.StatusListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.pubsub.PubSubConnectionEntry;
import org.redisson.pubsub.PublishSubscribeService;

public class RedissonTopic
implements RTopic {
    final PublishSubscribeService subscribeService;
    final CommandAsyncExecutor commandExecutor;
    final String name;
    final ChannelName channelName;
    final Codec codec;

    public RedissonTopic(CommandAsyncExecutor commandExecutor, String name) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor, name);
    }

    public static RedissonTopic createRaw(CommandAsyncExecutor commandExecutor, String name) {
        return new RedissonTopic(commandExecutor.getConnectionManager().getCodec(), commandExecutor, NameMapper.direct(), name);
    }

    public static RedissonTopic createRaw(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        return new RedissonTopic(codec, commandExecutor, NameMapper.direct(), name);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        this(codec, commandExecutor, commandExecutor.getConnectionManager().getConfig().getNameMapper(), name);
    }

    public RedissonTopic(Codec codec, CommandAsyncExecutor commandExecutor, NameMapper nameMapper, String name) {
        this.commandExecutor = commandExecutor;
        this.name = nameMapper.map(name);
        this.channelName = new ChannelName(this.name);
        this.codec = codec;
        this.subscribeService = commandExecutor.getConnectionManager().getSubscribeService();
    }

    @Override
    public List<String> getChannelNames() {
        return Collections.singletonList(this.name);
    }

    @Override
    public long publish(Object message) {
        return this.commandExecutor.get(this.publishAsync(message));
    }

    protected String getName() {
        return this.name;
    }

    protected String getName(Object o) {
        return this.name;
    }

    @Override
    public RFuture<Long> publishAsync(Object message) {
        String name = this.getName(message);
        return this.commandExecutor.writeAsync(name, (Codec)StringCodec.INSTANCE, RedisCommands.PUBLISH, name, this.commandExecutor.encode(this.codec, message));
    }

    @Override
    public int addListener(StatusListener listener) {
        RFuture<Integer> future = this.addListenerAsync(listener);
        return (Integer)this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public <M> int addListener(Class<M> type, MessageListener<? extends M> listener) {
        RFuture<Integer> future = this.addListenerAsync(type, listener);
        return (Integer)this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public RFuture<Integer> addListenerAsync(StatusListener listener) {
        PubSubStatusListener pubSubListener = new PubSubStatusListener(listener, this.name);
        return this.addListenerAsync(pubSubListener);
    }

    @Override
    public <M> RFuture<Integer> addListenerAsync(Class<M> type, MessageListener<M> listener) {
        PubSubMessageListener<M> pubSubListener = new PubSubMessageListener<M>(type, listener, this.name);
        return this.addListenerAsync(pubSubListener);
    }

    protected RFuture<Integer> addListenerAsync(RedisPubSubListener<?> pubSubListener) {
        CompletableFuture<PubSubConnectionEntry> future = this.subscribeService.subscribe(this.codec, this.channelName, pubSubListener);
        CompletionStage f = future.thenApply(res -> System.identityHashCode(pubSubListener));
        return new CompletableFutureWrapper<Integer>((CompletableFuture<Integer>)f);
    }

    @Override
    public void removeAllListeners() {
        this.commandExecutor.get(this.removeAllListenersAsync());
    }

    @Override
    public RFuture<Void> removeAllListenersAsync() {
        CompletableFuture<Void> f = this.subscribeService.removeAllListenersAsync(PubSubType.UNSUBSCRIBE, this.channelName);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void removeListener(MessageListener<?> listener) {
        RFuture<Void> future = this.removeListenerAsync(listener);
        this.commandExecutor.get(future.toCompletableFuture());
    }

    @Override
    public RFuture<Void> removeListenerAsync(MessageListener<?> listener) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.UNSUBSCRIBE, this.channelName, listener);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public RFuture<Void> removeListenerAsync(Integer ... listenerIds) {
        CompletableFuture<Void> f = this.subscribeService.removeListenerAsync(PubSubType.UNSUBSCRIBE, this.channelName, listenerIds);
        return new CompletableFutureWrapper<Void>(f);
    }

    @Override
    public void removeListener(Integer ... listenerIds) {
        this.commandExecutor.get(this.removeListenerAsync(listenerIds).toCompletableFuture());
    }

    @Override
    public int countListeners() {
        PubSubConnectionEntry entry = this.subscribeService.getPubSubEntry(this.channelName);
        if (entry != null) {
            return entry.countListeners(this.channelName);
        }
        return 0;
    }

    @Override
    public RFuture<Long> countSubscribersAsync() {
        return this.commandExecutor.writeAsync(this.name, (Codec)LongCodec.INSTANCE, RedisCommands.PUBSUB_NUMSUB, this.name);
    }

    @Override
    public long countSubscribers() {
        return this.commandExecutor.get(this.countSubscribersAsync());
    }
}

