/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.concurrent.atomic.LongAdder;
import org.redisson.RedissonBaseAdder;
import org.redisson.api.RFuture;
import org.redisson.api.RLongAdder;
import org.redisson.api.RedissonClient;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonLongAdder
extends RedissonBaseAdder<Long>
implements RLongAdder {
    private final RedissonClient redisson;
    private final LongAdder counter = new LongAdder();

    public RedissonLongAdder(CommandAsyncExecutor connectionManager, String name, RedissonClient redisson) {
        super(connectionManager, name, redisson);
        this.redisson = redisson;
    }

    @Override
    protected void doReset() {
        this.counter.reset();
    }

    @Override
    protected RFuture<Long> addAndGetAsync(String id) {
        return this.redisson.getAtomicLong(this.getCounterName(id)).getAndAddAsync(this.counter.sum());
    }

    @Override
    protected RFuture<Long> getAndDeleteAsync(String id) {
        return this.redisson.getAtomicLong(this.getCounterName(id)).getAndDeleteAsync();
    }

    @Override
    public void add(long x) {
        this.counter.add(x);
    }

    @Override
    public void increment() {
        this.add(1L);
    }

    @Override
    public void decrement() {
        this.add(-1L);
    }

    @Override
    public long sum() {
        return (Long)this.get(this.sumAsync());
    }
}

