/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import io.netty.channel.ChannelFuture;
import java.util.EventListener;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.PubSubMessageListener;
import org.redisson.PubSubPatternMessageListener;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubConnection;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.SubscribeListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.pubsub.PubSubStatusMessage;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.connection.ConnectionManager;

public class PubSubConnectionEntry {
    private final AtomicInteger subscribedChannelsAmount;
    private final RedisPubSubConnection conn;
    private final ConcurrentMap<ChannelName, SubscribeListener> subscribeChannelListeners = new ConcurrentHashMap<ChannelName, SubscribeListener>();
    private final ConcurrentMap<ChannelName, Queue<RedisPubSubListener<?>>> channelListeners = new ConcurrentHashMap();
    private static final Queue<RedisPubSubListener<?>> EMPTY_QUEUE = new LinkedList();
    private final ConnectionManager connectionManager;

    public PubSubConnectionEntry(RedisPubSubConnection conn, ConnectionManager connectionManager) {
        this.conn = conn;
        this.connectionManager = connectionManager;
        this.subscribedChannelsAmount = new AtomicInteger(connectionManager.getConfig().getSubscriptionsPerConnection());
    }

    public int countListeners(ChannelName channelName) {
        return this.channelListeners.getOrDefault(channelName, EMPTY_QUEUE).size();
    }

    public boolean hasListeners(ChannelName channelName) {
        return this.channelListeners.containsKey(channelName);
    }

    public Queue<RedisPubSubListener<?>> getListeners(ChannelName channelName) {
        return this.channelListeners.getOrDefault(channelName, EMPTY_QUEUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        Queue oldQueue;
        if (listener == null) {
            return;
        }
        Queue<RedisPubSubListener<Object>> queue = (ConcurrentLinkedQueue)this.channelListeners.get(channelName);
        if (queue == null && (oldQueue = (Queue)this.channelListeners.putIfAbsent(channelName, queue = new ConcurrentLinkedQueue())) != null) {
            queue = oldQueue;
        }
        boolean deleted = false;
        ConcurrentLinkedQueue concurrentLinkedQueue = queue;
        synchronized (concurrentLinkedQueue) {
            if (this.channelListeners.get(channelName) != queue) {
                deleted = true;
            } else {
                queue.add(listener);
            }
        }
        if (deleted) {
            this.addListener(channelName, listener);
            return;
        }
        this.conn.addListener(listener);
    }

    public boolean removeListener(ChannelName channelName, EventListener msgListener) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (listener instanceof PubSubMessageListener && ((PubSubMessageListener)listener).getListener() == msgListener) {
                this.removeListener(channelName, listener);
                return true;
            }
            if (!(listener instanceof PubSubPatternMessageListener) || ((PubSubPatternMessageListener)listener).getListener() != msgListener) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    public boolean removeListener(ChannelName channelName, int listenerId) {
        Queue listeners = (Queue)this.channelListeners.get(channelName);
        for (RedisPubSubListener listener : listeners) {
            if (System.identityHashCode(listener) != listenerId) continue;
            this.removeListener(channelName, listener);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ChannelName channelName, RedisPubSubListener<?> listener) {
        Queue queue;
        Queue queue2 = queue = (Queue)this.channelListeners.get(channelName);
        synchronized (queue2) {
            if (queue.remove(listener) && queue.isEmpty()) {
                this.channelListeners.remove(channelName);
            }
        }
        this.conn.removeListener(listener);
    }

    public int tryAcquire() {
        int value;
        do {
            if ((value = this.subscribedChannelsAmount.get()) != 0) continue;
            return -1;
        } while (!this.subscribedChannelsAmount.compareAndSet(value, value - 1));
        return value - 1;
    }

    public int release() {
        return this.subscribedChannelsAmount.incrementAndGet();
    }

    public void subscribe(Codec codec, PubSubType type, ChannelName channelName, CompletableFuture<Void> subscribeFuture) {
        ChannelFuture future = PubSubType.SUBSCRIBE == type ? this.conn.subscribe(codec, channelName) : (PubSubType.SSUBSCRIBE == type ? this.conn.ssubscribe(codec, channelName) : this.conn.psubscribe(codec, channelName));
        future.addListener(future1 -> {
            if (!future1.isSuccess()) {
                subscribeFuture.completeExceptionally(future1.cause());
                return;
            }
            this.connectionManager.newTimeout(t -> subscribeFuture.completeExceptionally(new RedisTimeoutException("Subscription timeout after " + this.connectionManager.getConfig().getTimeout() + "ms. Check network and/or increase 'timeout' parameter.")), this.connectionManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
        });
    }

    public SubscribeListener getSubscribeFuture(ChannelName channel, PubSubType type) {
        SubscribeListener listener = (SubscribeListener)this.subscribeChannelListeners.get(channel);
        if (listener == null) {
            listener = new SubscribeListener(channel, type);
            SubscribeListener oldSubscribeListener = this.subscribeChannelListeners.putIfAbsent(channel, listener);
            if (oldSubscribeListener != null) {
                listener = oldSubscribeListener;
            } else {
                this.conn.addListener(listener);
            }
        }
        return listener;
    }

    public void unsubscribe(final PubSubType commandType, final ChannelName channel, final RedisPubSubListener<?> listener) {
        final AtomicBoolean executed = new AtomicBoolean();
        this.conn.addListener(new BaseRedisPubSubListener(){

            @Override
            public boolean onStatus(PubSubType type, CharSequence ch) {
                if (type == commandType && channel.equals(ch)) {
                    executed.set(true);
                    PubSubConnectionEntry.this.conn.removeListener(this);
                    PubSubConnectionEntry.this.removeListeners(channel);
                    if (listener != null) {
                        listener.onStatus(type, ch);
                    }
                    return true;
                }
                return false;
            }
        });
        ChannelFuture future = this.conn.unsubscribe(commandType, channel);
        future.addListener(f -> {
            if (!f.isSuccess()) {
                return;
            }
            this.connectionManager.newTimeout(timeout -> {
                if (executed.get()) {
                    return;
                }
                this.conn.onMessage(new PubSubStatusMessage(commandType, channel));
            }, this.connectionManager.getConfig().getTimeout(), TimeUnit.MILLISECONDS);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeListeners(ChannelName channel) {
        this.conn.removeDisconnectListener(channel);
        SubscribeListener s = (SubscribeListener)this.subscribeChannelListeners.remove(channel);
        this.conn.removeListener(s);
        Queue queue = (Queue)this.channelListeners.get(channel);
        if (queue != null) {
            Queue queue2 = queue;
            synchronized (queue2) {
                this.channelListeners.remove(channel);
            }
            for (RedisPubSubListener listener : queue) {
                this.conn.removeListener(listener);
            }
        }
    }

    public RedisPubSubConnection getConnection() {
        return this.conn;
    }

    public String toString() {
        return "PubSubConnectionEntry [subscribedChannelsAmount=" + this.subscribedChannelsAmount + ", conn=" + this.conn + "]";
    }
}

