/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;

public class RedisURI {
    private final boolean ssl;
    private final String host;
    private final int port;
    private String username;
    private String password;

    public RedisURI(String scheme, String host, int port) {
        this.ssl = "rediss".equals(scheme);
        this.host = host;
        this.port = port;
    }

    public RedisURI(String uri) {
        if (!uri.startsWith("redis://") && !uri.startsWith("rediss://")) {
            throw new IllegalArgumentException("Redis url should start with redis:// or rediss:// (for SSL connection)");
        }
        String urlHost = uri.replaceFirst("redis://", "http://").replaceFirst("rediss://", "http://");
        String ipV6Host = uri.substring(uri.indexOf("://") + 3, uri.lastIndexOf(":"));
        if (ipV6Host.contains("@")) {
            ipV6Host = ipV6Host.split("@")[1];
        }
        if (ipV6Host.contains(":")) {
            urlHost = urlHost.replace(ipV6Host, "[" + ipV6Host + "]");
        }
        try {
            String[] details;
            URL url = new URL(urlHost);
            if (url.getUserInfo() != null && (details = url.getUserInfo().split(":", 2)).length == 2) {
                if (!details[0].isEmpty()) {
                    this.username = details[0];
                }
                this.password = details[1];
            }
            this.host = url.getHost();
            this.port = url.getPort();
            this.ssl = uri.startsWith("rediss://");
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getScheme() {
        if (this.ssl) {
            return "rediss";
        }
        return "redis";
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isIP() {
        return NetUtil.createByteArrayFromIpAddressString(this.host) != null;
    }

    private static String trimIpv6Brackets(String host) {
        if (host.startsWith("[") && host.endsWith("]")) {
            return host.substring(1, host.length() - 1);
        }
        return host;
    }

    public static boolean compare(InetSocketAddress entryAddr, RedisURI addr) {
        return (entryAddr.getHostName() != null && entryAddr.getHostName().equals(RedisURI.trimIpv6Brackets(addr.getHost())) || entryAddr.getAddress().getHostAddress().equals(RedisURI.trimIpv6Brackets(addr.getHost()))) && entryAddr.getPort() == addr.getPort();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RedisURI redisURI = (RedisURI)o;
        return this.ssl == redisURI.ssl && this.port == redisURI.port && Objects.equals(this.host, redisURI.host);
    }

    public int hashCode() {
        return Objects.hash(this.ssl, this.host, this.port);
    }

    public String toString() {
        return this.getScheme() + "://" + RedisURI.trimIpv6Brackets(this.host) + ":" + this.port;
    }
}

