/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.rx;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Action;
import io.reactivex.rxjava3.functions.LongConsumer;
import io.reactivex.rxjava3.processors.ReplayProcessor;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.redisson.command.CommandAsyncService;
import org.redisson.connection.ConnectionManager;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.rx.CommandRxExecutor;

public class CommandRxService
extends CommandAsyncService
implements CommandRxExecutor {
    public CommandRxService(ConnectionManager connectionManager, RedissonObjectBuilder objectBuilder) {
        super(connectionManager, objectBuilder, RedissonObjectBuilder.ReferenceType.RXJAVA);
    }

    @Override
    public <R> Flowable<R> flowable(final Callable<CompletableFuture<R>> supplier) {
        final ReplayProcessor p = ReplayProcessor.create();
        return p.doOnRequest(new LongConsumer(){

            @Override
            public void accept(long t) throws Exception {
                CompletableFuture future;
                try {
                    future = (CompletableFuture)supplier.call();
                }
                catch (Exception e2) {
                    p.onError(e2);
                    return;
                }
                p.doOnCancel(new Action(){

                    @Override
                    public void run() throws Exception {
                        future.cancel(true);
                    }
                });
                future.whenComplete((res, e) -> {
                    if (e != null) {
                        if (e instanceof CompletionException) {
                            e = e.getCause();
                        }
                        p.onError((Throwable)e);
                        return;
                    }
                    if (res != null) {
                        p.onNext(res);
                    }
                    p.onComplete();
                });
            }
        });
    }
}

