/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.AttributeKey;
import io.netty.util.Timeout;
import java.util.Deque;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.redisson.RedissonShutdownException;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisException;
import org.redisson.client.RedisTimeoutException;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.CommandsQueue;
import org.redisson.client.handler.CommandsQueuePubSub;
import org.redisson.client.protocol.CommandData;
import org.redisson.client.protocol.CommandsData;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.misc.CompletableFutureWrapper;
import org.redisson.misc.LogHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisConnection
implements RedisCommands {
    private static final Logger LOG = LoggerFactory.getLogger(RedisConnection.class);
    private static final AttributeKey<RedisConnection> CONNECTION = AttributeKey.valueOf("connection");
    final RedisClient redisClient;
    private volatile CompletableFuture<Void> fastReconnect;
    private volatile boolean closed;
    volatile Channel channel;
    private CompletableFuture<?> connectionPromise;
    private long lastUsageTime;
    private Runnable connectedListener;
    private Runnable disconnectedListener;
    private final AtomicInteger usage = new AtomicInteger();

    public <C> RedisConnection(RedisClient redisClient, Channel channel, CompletableFuture<C> connectionPromise) {
        this.redisClient = redisClient;
        this.connectionPromise = connectionPromise;
        this.updateChannel(channel);
        this.lastUsageTime = System.nanoTime();
        LOG.debug("Connection created " + redisClient);
    }

    protected RedisConnection(RedisClient redisClient) {
        this.redisClient = redisClient;
    }

    public void fireConnected() {
        if (this.connectedListener != null) {
            this.connectedListener.run();
        }
    }

    public int incUsage() {
        return this.usage.incrementAndGet();
    }

    public int getUsage() {
        return this.usage.get();
    }

    public int decUsage() {
        return this.usage.decrementAndGet();
    }

    public void setConnectedListener(Runnable connectedListener) {
        this.connectedListener = connectedListener;
    }

    public void fireDisconnected() {
        if (this.disconnectedListener != null) {
            this.disconnectedListener.run();
        }
    }

    public void setDisconnectedListener(Runnable disconnectedListener) {
        this.disconnectedListener = disconnectedListener;
    }

    public <C extends RedisConnection> CompletableFuture<C> getConnectionPromise() {
        return this.connectionPromise;
    }

    public static <C extends RedisConnection> C getFrom(Channel channel) {
        return (C)channel.attr(CONNECTION).get();
    }

    public CommandData<?, ?> getLastCommand() {
        QueueCommandHolder holder;
        Deque<QueueCommandHolder> queue = this.channel.attr(CommandsQueue.COMMANDS_QUEUE).get();
        if (queue != null && (holder = queue.peekLast()) != null && holder.getCommand() instanceof CommandData) {
            return (CommandData)holder.getCommand();
        }
        return null;
    }

    public CommandData<?, ?> getCurrentCommand() {
        QueueCommandHolder holder;
        Queue queue = this.channel.attr(CommandsQueue.COMMANDS_QUEUE).get();
        if (queue != null && (holder = (QueueCommandHolder)queue.peek()) != null && holder.getCommand() instanceof CommandData) {
            return (CommandData)holder.getCommand();
        }
        QueueCommand command = this.channel.attr(CommandsQueuePubSub.CURRENT_COMMAND).get();
        if (command instanceof CommandData) {
            return (CommandData)command;
        }
        return null;
    }

    public long getLastUsageTime() {
        return this.lastUsageTime;
    }

    public void setLastUsageTime(long lastUsageTime) {
        this.lastUsageTime = lastUsageTime;
    }

    public boolean isOpen() {
        return this.channel.isOpen();
    }

    public boolean isActive() {
        return this.channel.isActive();
    }

    public void updateChannel(Channel channel) {
        if (channel == null) {
            throw new NullPointerException();
        }
        this.channel = channel;
        channel.attr(CONNECTION).set(this);
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }

    public <R> R await(CompletableFuture<R> future) {
        try {
            return future.get(this.redisClient.getCommandTimeout(), TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RedisException) {
                throw (RedisException)e.getCause();
            }
            throw new RedisException("Unexpected exception while processing command", e.getCause());
        }
        catch (TimeoutException e) {
            RedisTimeoutException ex = new RedisTimeoutException("Command execution timeout for " + this.redisClient.getAddr());
            future.completeExceptionally(ex);
            throw ex;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
    }

    public <T> T sync(RedisCommand<T> command, Object ... params) {
        return (T)this.sync(null, command, params);
    }

    public <T, R> ChannelFuture send(CommandData<T, R> data) {
        return this.channel.writeAndFlush(data);
    }

    public ChannelFuture send(CommandsData data) {
        return this.channel.writeAndFlush(data);
    }

    public <T, R> R sync(Codec encoder, RedisCommand<T> command, Object ... params) {
        CompletableFuture promise = new CompletableFuture();
        this.send(new CommandData(promise, encoder, command, params));
        return (R)this.await(promise);
    }

    public <T, R> RFuture<R> async(RedisCommand<T> command, Object ... params) {
        return this.async(-1L, command, params);
    }

    public <T, R> RFuture<R> async(long timeout, RedisCommand<T> command, Object ... params) {
        return this.async(timeout, null, command, params);
    }

    public <T, R> RFuture<R> async(Codec encoder, RedisCommand<T> command, Object ... params) {
        return this.async(-1L, encoder, command, params);
    }

    public <T, R> RFuture<R> async(long timeout, Codec encoder, RedisCommand<T> command, Object ... params) {
        CompletableFuture promise = new CompletableFuture();
        if (timeout == -1L) {
            timeout = this.redisClient.getCommandTimeout();
        }
        if (this.redisClient.getEventLoopGroup().isShuttingDown()) {
            RedissonShutdownException cause = new RedissonShutdownException("Redisson is shutdown");
            return new CompletableFutureWrapper(cause);
        }
        Timeout scheduledFuture = this.redisClient.getTimer().newTimeout(t -> {
            RedisTimeoutException ex = new RedisTimeoutException("Command execution timeout for command: " + LogHelper.toString(command, params) + ", Redis client: " + this.redisClient);
            promise.completeExceptionally(ex);
        }, timeout, TimeUnit.MILLISECONDS);
        promise.whenComplete((res, e) -> scheduledFuture.cancel());
        ChannelFuture writeFuture = this.send(new CommandData(promise, encoder, command, params));
        writeFuture.addListener(future -> {
            if (!future.isSuccess()) {
                promise.completeExceptionally(future.cause());
            }
        });
        return new CompletableFutureWrapper(promise);
    }

    public <T, R> CommandData<T, R> create(Codec encoder, RedisCommand<T> command, Object ... params) {
        CompletableFuture promise = new CompletableFuture();
        return new CommandData(promise, encoder, command, params);
    }

    private void setClosed(boolean closed) {
        this.closed = closed;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isFastReconnect() {
        return this.fastReconnect != null;
    }

    public void clearFastReconnect() {
        this.fastReconnect.complete(null);
        this.fastReconnect = null;
    }

    private void close() {
        CommandData<?, ?> command = this.getCurrentCommand();
        if (command != null && command.isBlockingCommand() || !this.connectionPromise.isDone()) {
            this.channel.close();
        } else {
            RFuture f = this.async(RedisCommands.QUIT, new Object[0]);
            f.whenComplete((res, e) -> this.channel.close());
        }
    }

    public CompletableFuture<Void> forceFastReconnectAsync() {
        CompletableFuture<Void> promise = new CompletableFuture<Void>();
        this.fastReconnect = promise;
        this.close();
        return promise;
    }

    public Channel getChannel() {
        return this.channel;
    }

    public ChannelFuture closeAsync() {
        this.setClosed(true);
        this.close();
        return this.channel.closeFuture();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + System.identityHashCode(this) + " [redisClient=" + this.redisClient + ", channel=" + this.channel + ", currentCommand=" + this.getCurrentCommand() + ", usage=" + this.usage + "]";
    }
}

