/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.handler;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.AttributeKey;
import java.util.Deque;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.client.WriteRedisConnectionException;
import org.redisson.client.protocol.QueueCommand;
import org.redisson.client.protocol.QueueCommandHolder;
import org.redisson.misc.LogHelper;

public class CommandsQueue
extends ChannelDuplexHandler {
    public static final AttributeKey<Deque<QueueCommandHolder>> COMMANDS_QUEUE = AttributeKey.valueOf("COMMANDS_QUEUE");
    private final AtomicBoolean lock = new AtomicBoolean();

    @Override
    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        super.channelRegistered(ctx);
        ctx.channel().attr(COMMANDS_QUEUE).set(new ConcurrentLinkedDeque());
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        Queue queue = ctx.channel().attr(COMMANDS_QUEUE).get();
        Iterator iterator = queue.iterator();
        while (iterator.hasNext()) {
            QueueCommandHolder command = (QueueCommandHolder)iterator.next();
            if (command.getCommand().isBlockingCommand()) continue;
            iterator.remove();
            command.getChannelPromise().tryFailure(new WriteRedisConnectionException("Channel has been closed! Can't write command: " + LogHelper.toString(command.getCommand()) + " to channel: " + ctx.channel()));
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof QueueCommand) {
            QueueCommand data = (QueueCommand)msg;
            QueueCommandHolder holder = new QueueCommandHolder(data, promise);
            Queue queue = ctx.channel().attr(COMMANDS_QUEUE).get();
            while (!this.lock.compareAndSet(false, true)) {
            }
            try {
                queue.add(holder);
                ctx.writeAndFlush(data, holder.getChannelPromise());
            }
            finally {
                this.lock.set(false);
            }
        } else {
            super.write(ctx, msg, promise);
        }
    }
}

