/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.redisson.RedissonSemaphore;
import org.redisson.api.RFuture;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonQueueSemaphore
extends RedissonSemaphore {
    private String queueName;
    private Object value;
    private Collection<?> values;

    public RedissonQueueSemaphore(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setValues(Collection<?> values) {
        this.values = values;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits) {
        ArrayList<Comparable<Integer>> params;
        if (this.values != null) {
            params = new ArrayList(this.values.size() + 1);
            params.add(Integer.valueOf(this.values.size()));
            for (Object value : this.values) {
                params.add(this.encode(value));
            }
        } else {
            params = new ArrayList<Comparable<Integer>>(2);
            params.add(Integer.valueOf(1));
            params.add(this.encode(this.value));
        }
        return this.commandExecutor.evalWriteNoRetryAsync(this.getRawName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); assert(value ~= false, 'Capacity of queue ' .. KEYS[1] .. ' has not been set'); if (tonumber(value) >= tonumber(ARGV[1])) then redis.call('decrby', KEYS[1], ARGV[1]); redis.call('rpush', KEYS[2], unpack(ARGV, 2, #ARGV));return 1; end; return 0;", Arrays.asList(this.getRawName(), this.queueName), params.toArray());
    }
}

