/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonObject;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

abstract class RedissonExpirable
extends RedissonObject
implements RExpirable {
    RedissonExpirable(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    RedissonExpirable(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public boolean expire(long timeToLive, TimeUnit timeUnit) {
        return this.get(this.expireAsync(timeToLive, timeUnit));
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, "", this.getRawName());
    }

    @Override
    public boolean expireAt(long timestamp) {
        return this.commandExecutor.get(this.expireAtAsync(timestamp));
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, "", this.getRawName());
    }

    @Override
    public boolean expire(Instant instant) {
        return this.get(this.expireAsync(instant));
    }

    @Override
    public boolean expireIfSet(Instant time) {
        return this.get(this.expireIfSetAsync(time));
    }

    @Override
    public RFuture<Boolean> expireIfSetAsync(Instant time) {
        return this.expireAtAsync(time.toEpochMilli(), "XX", this.getRawName());
    }

    @Override
    public boolean expireIfNotSet(Instant time) {
        return this.get(this.expireIfNotSetAsync(time));
    }

    @Override
    public RFuture<Boolean> expireIfNotSetAsync(Instant time) {
        return this.expireAtAsync(time.toEpochMilli(), "NX", this.getRawName());
    }

    @Override
    public boolean expireIfGreater(Instant time) {
        return this.get(this.expireIfGreaterAsync(time));
    }

    @Override
    public RFuture<Boolean> expireIfGreaterAsync(Instant time) {
        return this.expireAtAsync(time.toEpochMilli(), "GT", this.getRawName());
    }

    @Override
    public boolean expireIfLess(Instant time) {
        return this.get(this.expireIfLessAsync(time));
    }

    @Override
    public RFuture<Boolean> expireIfLessAsync(Instant time) {
        return this.expireAtAsync(time.toEpochMilli(), "LT", this.getRawName());
    }

    @Override
    public RFuture<Boolean> expireAsync(Instant instant) {
        return this.expireAtAsync(instant.toEpochMilli(), "", this.getRawName());
    }

    @Override
    public boolean expire(Duration duration) {
        return this.get(this.expireAsync(duration));
    }

    @Override
    public RFuture<Boolean> expireAsync(Duration duration) {
        return this.expireAsync(duration.toMillis(), TimeUnit.MILLISECONDS, "", this.getRawName());
    }

    @Override
    public boolean expireAt(Date timestamp) {
        return this.expireAt(timestamp.getTime());
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        return this.expireAtAsync(timestamp.getTime());
    }

    @Override
    public boolean expireIfSet(Duration duration) {
        return this.get(this.expireIfSetAsync(duration));
    }

    @Override
    public RFuture<Boolean> expireIfSetAsync(Duration duration) {
        return this.expireAsync(duration.toMillis(), TimeUnit.MILLISECONDS, "XX", this.getRawName());
    }

    @Override
    public boolean expireIfNotSet(Duration duration) {
        return this.get(this.expireIfNotSetAsync(duration));
    }

    @Override
    public RFuture<Boolean> expireIfNotSetAsync(Duration duration) {
        return this.expireAsync(duration.toMillis(), TimeUnit.MILLISECONDS, "NX", this.getRawName());
    }

    @Override
    public boolean expireIfGreater(Duration duration) {
        return this.get(this.expireIfGreaterAsync(duration));
    }

    @Override
    public RFuture<Boolean> expireIfGreaterAsync(Duration duration) {
        return this.expireAsync(duration.toMillis(), TimeUnit.MILLISECONDS, "GT", this.getRawName());
    }

    @Override
    public boolean expireIfLess(Duration duration) {
        return this.get(this.expireIfLessAsync(duration));
    }

    @Override
    public RFuture<Boolean> expireIfLessAsync(Duration duration) {
        return this.expireAsync(duration.toMillis(), TimeUnit.MILLISECONDS, "LT", this.getRawName());
    }

    @Override
    public boolean clearExpire() {
        return this.commandExecutor.get(this.clearExpireAsync());
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.PERSIST, this.getRawName());
    }

    @Override
    public long remainTimeToLive() {
        return this.commandExecutor.get(this.remainTimeToLiveAsync());
    }

    @Override
    public RFuture<Long> remainTimeToLiveAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.PTTL, this.getRawName());
    }

    @Override
    public long getExpireTime() {
        return this.get(this.getExpireTimeAsync());
    }

    @Override
    public RFuture<Long> getExpireTimeAsync() {
        return this.commandExecutor.readAsync(this.getRawName(), (Codec)StringCodec.INSTANCE, RedisCommands.PEXPIRETIME, this.getRawName());
    }

    protected RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit, String param, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local result = 0;for j = 1, #KEYS, 1 do local expireSet; if ARGV[2] ~= '' then expireSet = redis.call('pexpire', KEYS[j], ARGV[1], ARGV[2]); else expireSet = redis.call('pexpire', KEYS[j], ARGV[1]); end; if expireSet == 1 then result = expireSet;end; end; return result; ", Arrays.asList(keys), timeUnit.toMillis(timeToLive), param);
    }

    protected RFuture<Boolean> expireAtAsync(long timestamp, String param, String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local result = 0;for j = 1, #KEYS, 1 do local expireSet; if ARGV[2] ~= '' then expireSet = redis.call('pexpireat', KEYS[j], ARGV[1], ARGV[2]); else expireSet = redis.call('pexpireat', KEYS[j], ARGV[1]); end; if expireSet == 1 then result = expireSet;end; end; return result; ", Arrays.asList(keys), timestamp, param);
    }

    protected RFuture<Boolean> clearExpireAsync(String ... keys) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local result = 0;for j = 1, #KEYS, 1 do local expireSet = redis.call('persist', KEYS[j]); if expireSet == 1 then result = expireSet;end; end; return result; ", Arrays.asList(keys), new Object[0]);
    }
}

