/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<T>
implements Iterator<T> {
    private Iterator<Iterator<T>> listIterator;
    private Iterator<T> currentIterator;
    private int limit;
    private int counter;

    public CompositeIterator(Iterator<Iterator<T>> iterators, int limit) {
        this.listIterator = iterators;
        this.limit = limit;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator == null || !this.currentIterator.hasNext()) {
            while (this.listIterator.hasNext()) {
                Iterator<T> iterator = this.listIterator.next();
                this.currentIterator = iterator;
                if (!iterator.hasNext()) continue;
                if (this.limit == 0) {
                    return true;
                }
                return this.limit >= this.counter + 1;
            }
            return false;
        }
        if (this.currentIterator.hasNext()) {
            if (this.limit == 0) {
                return true;
            }
            return this.limit >= this.counter + 1;
        }
        return false;
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.counter;
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        if (this.currentIterator == null) {
            throw new IllegalStateException("next() has not yet been called");
        }
        this.currentIterator.remove();
    }
}

