/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.SlotCallback;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.BucketsDecoder;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.RedissonPromise;

public class RedissonBuckets
implements RBuckets {
    protected final Codec codec;
    protected final CommandAsyncExecutor commandExecutor;

    public RedissonBuckets(CommandAsyncExecutor commandExecutor) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Codec codec, CommandAsyncExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        RFuture<Boolean> future = this.trySetAsync(buckets);
        return this.commandExecutor.get(future);
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        if (keys.length == 0) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        CompositeCodec commandCodec = new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("MGET", new MapGetAllDecoder(Arrays.asList(keys), 0));
        return this.commandExecutor.readBatchedAsync(commandCodec, command, new SlotCallback<Map<Object, Object>, Map<String, V>>(){
            final Map<String, V> results = new ConcurrentHashMap();

            @Override
            public void onSlotResult(Map<Object, Object> result) {
                for (Map.Entry<Object, Object> entry : result.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.results.put((String)entry.getKey(), entry.getValue());
                }
            }

            @Override
            public Map<String, V> onFinish() {
                return this.results;
            }

            @Override
            public RedisCommand<Map<Object, Object>> createCommand(List<String> keys) {
                return new RedisCommand<Map<Object, Object>>("MGET", new BucketsDecoder(keys));
            }
        }, keys);
    }

    @Override
    public RFuture<Boolean> trySetAsync(final Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSETNX, new SlotCallback<Boolean, Boolean>(){
            final AtomicBoolean result = new AtomicBoolean(true);

            @Override
            public void onSlotResult(Boolean result) {
                if (!result.booleanValue() && this.result.get()) {
                    this.result.set(result);
                }
            }

            @Override
            public Boolean onFinish() {
                return this.result.get();
            }

            @Override
            public Object[] createParams(List<String> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (String key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(buckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, buckets.keySet().toArray(new String[0]));
    }

    @Override
    public RFuture<Void> setAsync(final Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        return this.commandExecutor.writeBatchedAsync(this.codec, RedisCommands.MSET, new SlotCallback<Void, Void>(){

            @Override
            public void onSlotResult(Void result) {
            }

            @Override
            public Void onFinish() {
                return null;
            }

            @Override
            public Object[] createParams(List<String> keys) {
                ArrayList<Object> params = new ArrayList<Object>(keys.size());
                for (String key : keys) {
                    params.add(key);
                    try {
                        params.add(RedissonBuckets.this.codec.getValueEncoder().encode(buckets.get(key)));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
                return params.toArray();
            }
        }, buckets.keySet().toArray(new String[0]));
    }
}

