/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.mapreduce;

import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.redisson.api.BatchResult;
import org.redisson.api.RBatch;
import org.redisson.api.RExecutorService;
import org.redisson.api.RFuture;
import org.redisson.api.RMapAsync;
import org.redisson.api.RObject;
import org.redisson.api.RedissonClient;
import org.redisson.api.mapreduce.RCollator;
import org.redisson.api.mapreduce.RMapReduceExecutor;
import org.redisson.api.mapreduce.RReducer;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.mapreduce.MapReduceTimeoutException;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;

abstract class MapReduceExecutor<M, VIn, KOut, VOut>
implements RMapReduceExecutor<VIn, KOut, VOut> {
    private final RedissonClient redisson;
    private final RExecutorService executorService;
    final String resultMapName;
    final Codec objectCodec;
    final String objectName;
    final Class<?> objectClass;
    final CommandAsyncExecutor commandExecutor;
    RReducer<KOut, VOut> reducer;
    M mapper;
    long timeout;

    MapReduceExecutor(RObject object, RedissonClient redisson, CommandAsyncExecutor commandExecutor) {
        this.objectName = object.getName();
        this.objectCodec = object.getCodec();
        this.objectClass = object.getClass();
        this.redisson = redisson;
        UUID id = UUID.randomUUID();
        this.resultMapName = object.getName() + ":result:" + id;
        this.executorService = redisson.getExecutorService("redisson_mapreduce");
        this.commandExecutor = commandExecutor;
    }

    protected void check(Object task) {
        if (task == null) {
            throw new NullPointerException("Task is not defined");
        }
        if (task.getClass().isAnonymousClass()) {
            throw new IllegalArgumentException("Task can't be created using anonymous class");
        }
        if (task.getClass().isMemberClass() && !Modifier.isStatic(task.getClass().getModifiers())) {
            throw new IllegalArgumentException("Task class is an inner class and it should be static");
        }
    }

    @Override
    public Map<KOut, VOut> execute() {
        return this.commandExecutor.get(this.executeAsync());
    }

    @Override
    public RFuture<Map<KOut, VOut>> executeAsync() {
        RedissonPromise promise = new RedissonPromise();
        RFuture future = this.executeMapperAsync(this.resultMapName, null);
        if (this.timeout > 0L) {
            this.commandExecutor.getConnectionManager().newTimeout(task -> promise.tryFailure(new MapReduceTimeoutException()), this.timeout, TimeUnit.MILLISECONDS);
        }
        this.addCancelHandling(promise, future);
        future.onComplete((res, e) -> {
            if (e != null) {
                promise.tryFailure((Throwable)e);
                return;
            }
            RBatch batch = this.redisson.createBatch();
            RMapAsync resultMap = batch.getMap(this.resultMapName, this.objectCodec);
            resultMap.readAllMapAsync().onComplete(new TransferListener(promise));
            resultMap.deleteAsync();
            RFuture<BatchResult<?>> batchFuture = batch.executeAsync();
            this.addCancelHandling(promise, batchFuture);
        });
        return promise;
    }

    private <T> void addCancelHandling(RPromise<T> promise, RFuture<?> future) {
        promise.onComplete((res, e) -> {
            if (promise.isCancelled()) {
                future.cancel(true);
            }
        });
    }

    @Override
    public void execute(String resultMapName) {
        this.commandExecutor.get(this.executeAsync(resultMapName));
    }

    @Override
    public RFuture<Void> executeAsync(String resultMapName) {
        return this.executeMapperAsync(resultMapName, null);
    }

    private <R> RFuture<R> executeMapperAsync(String resultMapName, RCollator<KOut, VOut, R> collator) {
        if (this.mapper == null) {
            throw new NullPointerException("Mapper is not defined");
        }
        if (this.reducer == null) {
            throw new NullPointerException("Reducer is not defined");
        }
        Callable<Object> task = this.createTask(resultMapName, collator);
        return this.executorService.submit((Callable)task);
    }

    protected abstract Callable<Object> createTask(String var1, RCollator<KOut, VOut, Object> var2);

    @Override
    public <R> R execute(RCollator<KOut, VOut, R> collator) {
        return this.commandExecutor.get(this.executeAsync(collator));
    }

    @Override
    public <R> RFuture<R> executeAsync(RCollator<KOut, VOut, R> collator) {
        this.check(collator);
        return this.executeMapperAsync(this.resultMapName, collator);
    }
}

