/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.redisson.RedissonList;
import org.redisson.api.RFuture;
import org.redisson.api.RQueue;
import org.redisson.api.RedissonClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonQueue<V>
extends RedissonList<V>
implements RQueue<V> {
    public RedissonQueue(CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(commandExecutor, name, redisson);
    }

    public RedissonQueue(Codec codec, CommandAsyncExecutor commandExecutor, String name, RedissonClient redisson) {
        super(codec, commandExecutor, name, redisson);
    }

    @Override
    public boolean offer(V e) {
        return this.get(this.offerAsync(e));
    }

    @Override
    public RFuture<Boolean> offerAsync(V e) {
        return this.addAsync(e);
    }

    @Override
    public V getFirst() {
        Object value = this.getValue(0);
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V removeFirst() {
        V value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public V remove() {
        return this.removeFirst();
    }

    @Override
    public RFuture<V> pollAsync() {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.LPOP, this.getRawName());
    }

    @Override
    public List<V> poll(int limit) {
        return this.get(this.pollAsync(limit));
    }

    @Override
    public RFuture<List<V>> pollAsync(int limit) {
        return this.commandExecutor.evalWriteAsync(this.getRawName(), this.codec, RedisCommands.EVAL_LIST, "local result = {};for i = 1, ARGV[1], 1 do local value = redis.call('lpop', KEYS[1]);if value ~= false then table.insert(result, value);else return result;end;end; return result;", Collections.singletonList(this.getRawName()), limit);
    }

    @Override
    public V poll() {
        return this.get(this.pollAsync());
    }

    @Override
    public V element() {
        return this.getFirst();
    }

    @Override
    public RFuture<V> peekAsync() {
        return this.getAsync(0);
    }

    @Override
    public V peek() {
        return this.getValue(0);
    }

    @Override
    public V pollLastAndOfferFirstTo(String queueName) {
        return this.get(this.pollLastAndOfferFirstToAsync(queueName));
    }

    @Override
    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        return this.commandExecutor.writeAsync(this.getRawName(), this.codec, RedisCommands.RPOPLPUSH, this.getRawName(), queueName);
    }
}

