/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Method;
import net.bytebuddy.implementation.bind.annotation.AllArguments;
import net.bytebuddy.implementation.bind.annotation.FieldProxy;
import net.bytebuddy.implementation.bind.annotation.FieldValue;
import net.bytebuddy.implementation.bind.annotation.Origin;
import net.bytebuddy.implementation.bind.annotation.RuntimeType;
import net.bytebuddy.implementation.bind.annotation.This;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonMap;
import org.redisson.RedissonObject;
import org.redisson.api.RFuture;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.client.RedisException;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.resolver.NamingScheme;

public class LiveObjectInterceptor {
    private final CommandAsyncExecutor commandExecutor;
    private final Class<?> originalClass;
    private final String idFieldName;
    private final Class<?> idFieldType;
    private final NamingScheme namingScheme;
    private final RedissonLiveObjectService service;

    public LiveObjectInterceptor(CommandAsyncExecutor commandExecutor, RedissonLiveObjectService service, Class<?> entityClass, String idFieldName) {
        this.service = service;
        this.commandExecutor = commandExecutor;
        this.originalClass = entityClass;
        this.idFieldName = idFieldName;
        this.namingScheme = commandExecutor.getObjectBuilder().getNamingScheme(entityClass);
        try {
            this.idFieldType = ClassUtils.getDeclaredField(this.originalClass, idFieldName).getType();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    @RuntimeType
    public Object intercept(@Origin Method method, @AllArguments Object[] args, @This Object me, @FieldValue(value="liveObjectId") Object id, @FieldProxy(value="liveObjectId") Setter idSetter, @FieldProxy(value="liveObjectId") Getter idGetter, @FieldValue(value="liveObjectLiveMap") RMap<String, ?> map, @FieldProxy(value="liveObjectLiveMap") Setter mapSetter, @FieldProxy(value="liveObjectLiveMap") Getter mapGetter) throws Exception {
        if ("setLiveObjectId".equals(method.getName())) {
            String idKey;
            block9: {
                if (args[0].getClass().isArray()) {
                    throw new UnsupportedOperationException("RId value cannot be an array.");
                }
                idKey = this.getMapKey(args[0]);
                if (map != null) {
                    if (((RedissonObject)((Object)map)).getRawName().equals(idKey)) {
                        return null;
                    }
                    try {
                        map.rename(this.getMapKey(args[0]));
                    }
                    catch (RedisException e) {
                        if (e.getMessage() != null && e.getMessage().startsWith("ERR no such key")) break block9;
                        throw e;
                    }
                }
            }
            RedissonMap liveMap = new RedissonMap(this.namingScheme.getCodec(), this.commandExecutor, idKey, null, null, null);
            mapSetter.setValue(liveMap);
            return null;
        }
        if ("getLiveObjectId".equals(method.getName())) {
            if (map == null) {
                return null;
            }
            return this.namingScheme.resolveId(((RedissonObject)((Object)map)).getRawName());
        }
        if ("delete".equals(method.getName())) {
            CommandBatchService ce = this.commandExecutor instanceof CommandBatchService ? (CommandBatchService)this.commandExecutor : new CommandBatchService(this.commandExecutor);
            Object idd = ((RLiveObject)me).getLiveObjectId();
            RFuture<Long> deleteFuture = this.service.delete(idd, me.getClass().getSuperclass(), this.namingScheme, ce);
            ce.execute();
            return deleteFuture.getNow() > 0L;
        }
        return method.invoke(map, args);
    }

    private String getMapKey(Object id) {
        return this.namingScheme.getName(this.originalClass, id);
    }

    public static interface Setter {
        public void setValue(Object var1);
    }

    public static interface Getter {
        public Object getValue();
    }
}

