/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import org.reactivestreams.Publisher;
import org.redisson.RedissonObject;
import org.redisson.ScanIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RLockReactive;
import org.redisson.api.RPermitExpirableSemaphoreReactive;
import org.redisson.api.RReadWriteLockReactive;
import org.redisson.api.RSemaphoreReactive;
import org.redisson.api.RSetCache;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.client.RedisClient;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.reactive.PublisherAdder;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonSetCacheReactive<V> {
    private final RSetCache<V> instance;
    private final RedissonReactiveClient redisson;

    public RedissonSetCacheReactive(RSetCache<V> instance, RedissonReactiveClient redisson) {
        this.instance = instance;
        this.redisson = redisson;
    }

    public Publisher<V> iterator() {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((ScanIterator)((Object)RedissonSetCacheReactive.this.instance)).scanIteratorAsync(((RedissonObject)((Object)RedissonSetCacheReactive.this.instance)).getRawName(), client, nextIterPos, null, 10);
            }
        });
    }

    public Publisher<Boolean> addAll(Publisher<? extends V> c) {
        return new PublisherAdder<V>(){

            @Override
            public RFuture<Boolean> add(Object o) {
                return RedissonSetCacheReactive.this.instance.addAsync(o);
            }
        }.addAll(c);
    }

    public RPermitExpirableSemaphoreReactive getPermitExpirableSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "permitexpirablesemaphore");
        return this.redisson.getPermitExpirableSemaphore(name);
    }

    public RSemaphoreReactive getSemaphore(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "semaphore");
        return this.redisson.getSemaphore(name);
    }

    public RLockReactive getFairLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "fairlock");
        return this.redisson.getFairLock(name);
    }

    public RReadWriteLockReactive getReadWriteLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "rw_lock");
        return this.redisson.getReadWriteLock(name);
    }

    public RLockReactive getLock(V value) {
        String name = ((RedissonObject)((Object)this.instance)).getLockByValue(value, "lock");
        return this.redisson.getLock(name);
    }
}

