/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonBuckets;
import org.redisson.RedissonKeys;
import org.redisson.RedissonMultiLock;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketsTrySetOperation;

public class RedissonTransactionalBuckets
extends RedissonBuckets {
    static final Object NULL = new Object();
    private long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private Map<String, Object> state = new HashMap<String, Object>();
    private final String transactionId;

    public RedissonTransactionalBuckets(CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(commandExecutor);
        this.timeout = timeout;
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
    }

    public RedissonTransactionalBuckets(Codec codec, CommandAsyncExecutor commandExecutor, long timeout, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor);
        this.timeout = timeout;
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        this.checkState();
        if (keys.length == 0) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        HashSet<String> keysToLoad = new HashSet<String>();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (String key : keys) {
            Object value = this.state.get(key);
            if (value != null) {
                if (value == NULL) continue;
                map.put(key, value);
                continue;
            }
            keysToLoad.add(key);
        }
        if (keysToLoad.isEmpty()) {
            return RedissonPromise.newSucceededFuture(map);
        }
        RedissonPromise result = new RedissonPromise();
        super.getAsync(keysToLoad.toArray(new String[keysToLoad.size()])).onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            map.putAll((Map<String, Object>)res);
            result.trySuccess(map);
        });
        return result;
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        this.checkState();
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.executeLocked(result, () -> {
            for (Map.Entry entry : buckets.entrySet()) {
                this.operations.add(new BucketSetOperation((String)entry.getKey(), this.getLockName((String)entry.getKey()), this.codec, entry.getValue(), this.transactionId));
                if (entry.getValue() == null) {
                    this.state.put((String)entry.getKey(), NULL);
                    continue;
                }
                this.state.put((String)entry.getKey(), entry.getValue());
            }
            result.trySuccess(null);
        }, buckets.keySet());
        return result;
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        this.checkState();
        RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, () -> {
            HashSet<String> keysToSet = new HashSet<String>();
            for (String key : buckets.keySet()) {
                Object value = this.state.get(key);
                if (value != null) {
                    if (value == NULL) continue;
                    this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                    result.trySuccess(false);
                    return;
                }
                keysToSet.add(key);
            }
            if (keysToSet.isEmpty()) {
                this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                this.state.putAll(buckets);
                result.trySuccess(true);
                return;
            }
            RedissonKeys keys = new RedissonKeys(this.commandExecutor);
            String[] ks = keysToSet.toArray(new String[keysToSet.size()]);
            keys.countExistsAsync(ks).onComplete((res, e) -> {
                if (e != null) {
                    result.tryFailure((Throwable)e);
                    return;
                }
                this.operations.add(new BucketsTrySetOperation(this.codec, buckets, this.transactionId));
                if (res == 0L) {
                    this.state.putAll(buckets);
                    result.trySuccess(true);
                } else {
                    result.trySuccess(false);
                }
            });
        }, buckets.keySet());
        return result;
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable, Collection<String> keys) {
        ArrayList<RLock> locks = new ArrayList<RLock>(keys.size());
        for (String key : keys) {
            RLock lock = this.getLock(key);
            locks.add(lock);
        }
        RedissonMultiLock multiLock = new RedissonMultiLock(locks.toArray(new RLock[locks.size()]));
        long threadId = Thread.currentThread().getId();
        multiLock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                multiLock.unlockAsync(threadId);
                promise.tryFailure((Throwable)e);
            }
        });
    }

    private RLock getLock(String name) {
        return new RedissonTransactionalLock(this.commandExecutor, this.getLockName(name), this.transactionId);
    }

    private String getLockName(String name) {
        return name + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

