/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.Callable;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.api.RFuture;
import org.redisson.api.RScoredSortedSetAsync;
import org.redisson.client.RedisClient;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.ElementsStream;
import org.redisson.reactive.SetReactiveIterator;
import reactor.core.publisher.Flux;

public class RedissonScoredSortedSetReactive<V> {
    private final RScoredSortedSetAsync<V> instance;

    public RedissonScoredSortedSetReactive(CommandReactiveExecutor commandExecutor, String name) {
        this(commandExecutor, name, new RedissonScoredSortedSet(commandExecutor, name, null));
    }

    private RedissonScoredSortedSetReactive(CommandReactiveExecutor commandExecutor, String name, RScoredSortedSetAsync<V> instance) {
        this.instance = instance;
    }

    public RedissonScoredSortedSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name) {
        this(codec, commandExecutor, name, new RedissonScoredSortedSet(codec, commandExecutor, name, null));
    }

    private RedissonScoredSortedSetReactive(Codec codec, CommandReactiveExecutor commandExecutor, String name, RScoredSortedSetAsync<V> instance) {
        this.instance = instance;
    }

    public Flux<V> takeFirstElements() {
        return ElementsStream.takeElements(new Callable<RFuture<V>>(){

            @Override
            public RFuture<V> call() throws Exception {
                return RedissonScoredSortedSetReactive.this.instance.takeFirstAsync();
            }
        });
    }

    public Flux<V> takeLastElements() {
        return ElementsStream.takeElements(new Callable<RFuture<V>>(){

            @Override
            public RFuture<V> call() throws Exception {
                return RedissonScoredSortedSetReactive.this.instance.takeLastAsync();
            }
        });
    }

    private Flux<V> scanIteratorReactive(final String pattern, final int count) {
        return Flux.create(new SetReactiveIterator<V>(){

            @Override
            protected RFuture<ListScanResult<Object>> scanIterator(RedisClient client, long nextIterPos) {
                return ((RedissonScoredSortedSet)RedissonScoredSortedSetReactive.this.instance).scanIteratorAsync(client, nextIterPos, pattern, count);
            }
        });
    }

    public String getName() {
        return ((RedissonScoredSortedSet)this.instance).getRawName();
    }

    public Flux<V> iterator() {
        return this.scanIteratorReactive(null, 10);
    }

    public Flux<V> iterator(String pattern) {
        return this.scanIteratorReactive(pattern, 10);
    }

    public Flux<V> iterator(int count) {
        return this.scanIteratorReactive(null, count);
    }

    public Flux<V> iterator(String pattern, int count) {
        return this.scanIteratorReactive(pattern, count);
    }
}

