/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonListMultimapCache;
import org.redisson.RedissonObject;
import org.redisson.RedissonScoredSortedSet;
import org.redisson.RedissonSemaphore;
import org.redisson.RedissonTopic;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RSemaphore;
import org.redisson.api.RTopic;
import org.redisson.api.listener.BaseStatusListener;
import org.redisson.api.listener.MessageListener;
import org.redisson.cache.CacheKey;
import org.redisson.cache.CacheValue;
import org.redisson.cache.LFUCacheMap;
import org.redisson.cache.LRUCacheMap;
import org.redisson.cache.LocalCachedMapClear;
import org.redisson.cache.LocalCachedMapDisable;
import org.redisson.cache.LocalCachedMapDisableAck;
import org.redisson.cache.LocalCachedMapDisabledKey;
import org.redisson.cache.LocalCachedMapEnable;
import org.redisson.cache.LocalCachedMapInvalidate;
import org.redisson.cache.LocalCachedMapUpdate;
import org.redisson.cache.LocalCachedMessageCodec;
import org.redisson.cache.NoneCacheMap;
import org.redisson.cache.ReferenceCacheMap;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonPromise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LocalCacheListener {
    public static final String TOPIC_SUFFIX = "topic";
    public static final String DISABLED_KEYS_SUFFIX = "disabled-keys";
    public static final String DISABLED_ACK_SUFFIX = ":topic";
    private ConcurrentMap<CacheKey, String> disabledKeys = new ConcurrentHashMap<CacheKey, String>();
    private static final Logger log = LoggerFactory.getLogger(LocalCacheListener.class);
    private String name;
    private CommandAsyncExecutor commandExecutor;
    private Map<?, ?> cache;
    private RObject object;
    private byte[] instanceId = new byte[16];
    private Codec codec;
    private LocalCachedMapOptions<?, ?> options;
    private long cacheUpdateLogTime;
    private volatile long lastInvalidate;
    private RTopic invalidationTopic;
    private int syncListenerId;
    private int reconnectionListenerId;

    public LocalCacheListener(String name, CommandAsyncExecutor commandExecutor, RObject object, Codec codec, LocalCachedMapOptions<?, ?> options, long cacheUpdateLogTime) {
        this.name = name;
        this.commandExecutor = commandExecutor;
        this.object = object;
        this.codec = codec;
        this.options = options;
        this.cacheUpdateLogTime = cacheUpdateLogTime;
        ThreadLocalRandom.current().nextBytes(this.instanceId);
    }

    public byte[] generateId() {
        byte[] id = new byte[16];
        ThreadLocalRandom.current().nextBytes(id);
        return id;
    }

    public byte[] getInstanceId() {
        return this.instanceId;
    }

    public ConcurrentMap<CacheKey, CacheValue> createCache(LocalCachedMapOptions<?, ?> options) {
        if (options.getCacheProvider() == LocalCachedMapOptions.CacheProvider.CAFFEINE) {
            Caffeine caffeineBuilder = Caffeine.newBuilder();
            if (options.getTimeToLiveInMillis() > 0L) {
                caffeineBuilder.expireAfterWrite(options.getTimeToLiveInMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.getMaxIdleInMillis() > 0L) {
                caffeineBuilder.expireAfterAccess(options.getMaxIdleInMillis(), TimeUnit.MILLISECONDS);
            }
            if (options.getCacheSize() > 0) {
                caffeineBuilder.maximumSize((long)options.getCacheSize());
            }
            if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
                caffeineBuilder.softValues();
            }
            if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
                caffeineBuilder.weakValues();
            }
            return caffeineBuilder.build().asMap();
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.NONE) {
            return new NoneCacheMap<CacheKey, CacheValue>(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LRU) {
            return new LRUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.LFU) {
            return new LFUCacheMap<CacheKey, CacheValue>(options.getCacheSize(), options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.SOFT) {
            return ReferenceCacheMap.soft(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        if (options.getEvictionPolicy() == LocalCachedMapOptions.EvictionPolicy.WEAK) {
            return ReferenceCacheMap.weak(options.getTimeToLiveInMillis(), options.getMaxIdleInMillis());
        }
        throw new IllegalArgumentException("Invalid eviction policy: " + (Object)((Object)options.getEvictionPolicy()));
    }

    public boolean isDisabled(Object key) {
        return this.disabledKeys.containsKey(key);
    }

    public void add(final Map<?, ?> cache) {
        this.cache = cache;
        this.invalidationTopic = RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, this.commandExecutor, this.getInvalidationTopicName());
        if (this.options.getReconnectionStrategy() != LocalCachedMapOptions.ReconnectionStrategy.NONE) {
            this.reconnectionListenerId = this.invalidationTopic.addListener(new BaseStatusListener(){

                @Override
                public void onSubscribe(String channel) {
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.CLEAR) {
                        cache.clear();
                    }
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD && LocalCacheListener.this.lastInvalidate > 0L) {
                        LocalCacheListener.this.loadAfterReconnection();
                    }
                }
            });
        }
        if (this.options.getSyncStrategy() != LocalCachedMapOptions.SyncStrategy.NONE) {
            this.syncListenerId = this.invalidationTopic.addListener(Object.class, new MessageListener<Object>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onMessage(CharSequence channel, Object msg) {
                    LocalCachedMapInvalidate invalidateMsg;
                    Serializable m;
                    if (msg instanceof LocalCachedMapDisable) {
                        m = (LocalCachedMapDisable)msg;
                        String requestId = ((LocalCachedMapDisable)m).getRequestId();
                        HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
                        for (byte[] keyHash : ((LocalCachedMapDisable)msg).getKeyHashes()) {
                            CacheKey key = new CacheKey(keyHash);
                            keysToDisable.add(key);
                        }
                        LocalCacheListener.this.disableKeys(requestId, keysToDisable, ((LocalCachedMapDisable)m).getTimeout());
                        RedissonTopic topic = RedissonTopic.createRaw(LocalCachedMessageCodec.INSTANCE, LocalCacheListener.this.commandExecutor, RedissonObject.suffixName(LocalCacheListener.this.name, (String)requestId + LocalCacheListener.DISABLED_ACK_SUFFIX));
                        topic.publishAsync(new LocalCachedMapDisableAck());
                    }
                    if (msg instanceof LocalCachedMapEnable) {
                        m = (LocalCachedMapEnable)msg;
                        for (Object keyHash : (String)((LocalCachedMapEnable)m).getKeyHashes()) {
                            CacheKey key = new CacheKey((byte[])keyHash);
                            LocalCacheListener.this.disabledKeys.remove(key, ((LocalCachedMapEnable)m).getRequestId());
                        }
                    }
                    if (msg instanceof LocalCachedMapClear) {
                        LocalCachedMapClear clearMsg = (LocalCachedMapClear)msg;
                        cache.clear();
                        if (clearMsg.isReleaseSemaphore()) {
                            RSemaphore semaphore = LocalCacheListener.this.getClearSemaphore(clearMsg.getRequestId());
                            semaphore.releaseAsync();
                        }
                    }
                    if (msg instanceof LocalCachedMapInvalidate && !Arrays.equals((invalidateMsg = (LocalCachedMapInvalidate)msg).getExcludedId(), LocalCacheListener.this.instanceId)) {
                        for (Object keyHash : (Object)invalidateMsg.getKeyHashes()) {
                            CacheKey key = new CacheKey((byte[])keyHash);
                            cache.remove(key);
                        }
                    }
                    if (msg instanceof LocalCachedMapUpdate) {
                        LocalCachedMapUpdate updateMsg = (LocalCachedMapUpdate)msg;
                        for (LocalCachedMapUpdate.Entry entry : updateMsg.getEntries()) {
                            ByteBuf keyBuf = Unpooled.wrappedBuffer(entry.getKey());
                            ByteBuf valueBuf = Unpooled.wrappedBuffer(entry.getValue());
                            try {
                                LocalCacheListener.this.updateCache(keyBuf, valueBuf);
                            }
                            catch (IOException e) {
                                log.error("Can't decode map entry", e);
                            }
                            finally {
                                keyBuf.release();
                                valueBuf.release();
                            }
                        }
                    }
                    if (LocalCacheListener.this.options.getReconnectionStrategy() == LocalCachedMapOptions.ReconnectionStrategy.LOAD) {
                        LocalCacheListener.this.lastInvalidate = System.currentTimeMillis();
                    }
                }
            });
            String disabledKeysName = RedissonObject.suffixName(this.name, DISABLED_KEYS_SUFFIX);
            RedissonListMultimapCache multimap = new RedissonListMultimapCache(null, this.codec, this.commandExecutor, disabledKeysName);
            for (LocalCachedMapDisabledKey key : multimap.readAllKeySet()) {
                HashSet<CacheKey> keysToDisable = new HashSet<CacheKey>();
                for (String hash : multimap.getAll(key)) {
                    CacheKey cacheKey = new CacheKey(ByteBufUtil.decodeHexDump(hash));
                    keysToDisable.add(cacheKey);
                }
                this.disableKeys(key.getRequestId(), keysToDisable, key.getTimeout());
            }
        }
    }

    public RFuture<Void> clearLocalCacheAsync() {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        byte[] id = this.generateId();
        RFuture<Long> future = this.invalidationTopic.publishAsync(new LocalCachedMapClear(id, true));
        future.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            RSemaphore semaphore = this.getClearSemaphore(id);
            semaphore.tryAcquireAsync(res.intValue(), 50L, TimeUnit.SECONDS).onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                semaphore.deleteAsync().onComplete((re, exc) -> {
                    if (exc != null) {
                        result.tryFailure((Throwable)exc);
                        return;
                    }
                    result.trySuccess(null);
                });
            });
        });
        return result;
    }

    public RTopic getInvalidationTopic() {
        return this.invalidationTopic;
    }

    public String getInvalidationTopicName() {
        return RedissonObject.suffixName(this.name, TOPIC_SUFFIX);
    }

    protected abstract void updateCache(ByteBuf var1, ByteBuf var2) throws IOException;

    private void disableKeys(final String requestId, final Set<CacheKey> keys, long timeout) {
        for (CacheKey key : keys) {
            this.disabledKeys.put(key, requestId);
            this.cache.remove(key);
        }
        this.commandExecutor.getConnectionManager().getGroup().schedule(new Runnable(){

            @Override
            public void run() {
                for (CacheKey cacheKey : keys) {
                    LocalCacheListener.this.disabledKeys.remove(cacheKey, requestId);
                }
            }
        }, timeout, TimeUnit.MILLISECONDS);
    }

    public void remove() {
        ArrayList<Integer> ids = new ArrayList<Integer>(2);
        if (this.syncListenerId != 0) {
            ids.add(this.syncListenerId);
        }
        if (this.reconnectionListenerId != 0) {
            ids.add(this.reconnectionListenerId);
        }
        this.invalidationTopic.removeListenerAsync(ids.toArray(new Integer[ids.size()]));
    }

    public String getUpdatesLogName() {
        return RedissonObject.prefixName("redisson__cache_updates_log", this.name);
    }

    private void loadAfterReconnection() {
        if (System.currentTimeMillis() - this.lastInvalidate > this.cacheUpdateLogTime) {
            this.cache.clear();
            return;
        }
        this.object.isExistsAsync().onComplete((res, e) -> {
            if (e != null) {
                log.error("Can't check existance", (Throwable)e);
                return;
            }
            if (!res.booleanValue()) {
                this.cache.clear();
                return;
            }
            RedissonScoredSortedSet logs = new RedissonScoredSortedSet(ByteArrayCodec.INSTANCE, this.commandExecutor, this.getUpdatesLogName(), null);
            logs.valueRangeAsync(this.lastInvalidate, true, Double.POSITIVE_INFINITY, true).onComplete((r, ex) -> {
                if (ex != null) {
                    log.error("Can't load update log", (Throwable)ex);
                    return;
                }
                for (byte[] entry : r) {
                    byte[] keyHash = Arrays.copyOf(entry, 16);
                    CacheKey key = new CacheKey(keyHash);
                    this.cache.remove(key);
                }
            });
        });
    }

    private RSemaphore getClearSemaphore(byte[] requestId) {
        String id = ByteBufUtil.hexDump(requestId);
        RedissonSemaphore semaphore = new RedissonSemaphore(this.commandExecutor, this.name + ":clear:" + id);
        return semaphore;
    }
}

