/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.liveobject.core;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentMap;
import org.redisson.RedissonBlockingDeque;
import org.redisson.RedissonBlockingQueue;
import org.redisson.RedissonDeque;
import org.redisson.RedissonList;
import org.redisson.RedissonLiveObjectService;
import org.redisson.RedissonMap;
import org.redisson.RedissonQueue;
import org.redisson.RedissonReference;
import org.redisson.RedissonSet;
import org.redisson.RedissonSortedSet;
import org.redisson.api.RLiveObject;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.RObjectReactive;
import org.redisson.api.RObjectRx;
import org.redisson.api.RedissonClient;
import org.redisson.api.RedissonReactiveClient;
import org.redisson.api.RedissonRxClient;
import org.redisson.api.annotation.REntity;
import org.redisson.api.annotation.RObjectField;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.ScoredEntry;
import org.redisson.client.protocol.decoder.ListScanResult;
import org.redisson.client.protocol.decoder.MapScanResult;
import org.redisson.codec.DefaultReferenceCodecProvider;
import org.redisson.codec.ReferenceCodecProvider;
import org.redisson.config.Config;
import org.redisson.liveobject.misc.ClassUtils;
import org.redisson.liveobject.resolver.NamingScheme;

public class RedissonObjectBuilder {
    private static final Map<Class<?>, Class<? extends RObject>> SUPPORTED_CLASS_MAPPING = new LinkedHashMap();
    private static final Map<Class<?>, CodecMethodRef> REFERENCES = new HashMap();
    private final Config config;
    private RedissonClient redisson;
    private RedissonReactiveClient redissonReactive;
    private RedissonRxClient redissonRx;
    private final ReferenceCodecProvider codecProvider = new DefaultReferenceCodecProvider();

    public RedissonObjectBuilder(RedissonClient redisson) {
        this.config = redisson.getConfig();
        this.redisson = redisson;
        Codec codec = this.config.getCodec();
        this.codecProvider.registerCodec(codec.getClass(), codec);
    }

    public RedissonObjectBuilder(RedissonReactiveClient redissonReactive) {
        this.config = redissonReactive.getConfig();
        this.redissonReactive = redissonReactive;
        Codec codec = this.config.getCodec();
        this.codecProvider.registerCodec(codec.getClass(), codec);
    }

    public RedissonObjectBuilder(RedissonRxClient redissonRx) {
        this.config = redissonRx.getConfig();
        this.redissonRx = redissonRx;
        Codec codec = this.config.getCodec();
        this.codecProvider.registerCodec(codec.getClass(), codec);
    }

    public void storeAsync(RObject ar, String fieldName, RMap<String, Object> liveMap) {
        Codec codec = ar.getCodec();
        if (codec != null) {
            this.codecProvider.registerCodec(codec.getClass(), codec);
        }
        liveMap.fastPutAsync(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
    }

    public void store(RObject ar, String fieldName, RMap<String, Object> liveMap) {
        Codec codec = ar.getCodec();
        if (codec != null) {
            this.codecProvider.registerCodec(codec.getClass(), codec);
        }
        liveMap.fastPut(fieldName, new RedissonReference(ar.getClass(), ar.getName(), codec));
    }

    public RObject createObject(Object id, Class<?> clazz, Class<?> fieldType, String fieldName) {
        Class<? extends RObject> mappedClass = this.getMappedClass(fieldType);
        try {
            if (mappedClass != null) {
                Codec fieldCodec = this.getFieldCodec(clazz, mappedClass, fieldName);
                NamingScheme fieldNamingScheme = this.getNamingScheme(clazz, fieldCodec);
                String referenceName = fieldNamingScheme.getFieldReferenceName(clazz, id, mappedClass, fieldName);
                return this.createRObject(this.redisson, mappedClass, referenceName, fieldCodec);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private Codec getFieldCodec(Class<?> rEntity, Class<? extends RObject> rObjectClass, String fieldName) throws ReflectiveOperationException {
        Field field = ClassUtils.getDeclaredField(rEntity, fieldName);
        if (field.isAnnotationPresent(RObjectField.class)) {
            RObjectField anno = field.getAnnotation(RObjectField.class);
            return this.codecProvider.getCodec(anno, rEntity, rObjectClass, fieldName, this.config);
        }
        REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
        return this.codecProvider.getCodec(anno, rEntity, this.config);
    }

    public NamingScheme getNamingScheme(Class<?> entityClass) {
        REntity anno = ClassUtils.getAnnotation(entityClass, REntity.class);
        Object codec = this.codecProvider.getCodec(anno, entityClass, this.config);
        return this.getNamingScheme(entityClass, (Codec)codec);
    }

    public NamingScheme getNamingScheme(Class<?> rEntity, Codec c) {
        REntity anno = ClassUtils.getAnnotation(rEntity, REntity.class);
        try {
            return anno.namingScheme().getDeclaredConstructor(Codec.class).newInstance(c);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Class<? extends RObject> getMappedClass(Class<?> cls) {
        for (Map.Entry<Class<?>, Class<RObject>> entrySet : SUPPORTED_CLASS_MAPPING.entrySet()) {
            if (!entrySet.getKey().isAssignableFrom(cls)) continue;
            return entrySet.getValue();
        }
        return null;
    }

    private static void fillCodecMethods(Map<Class<?>, CodecMethodRef> map, Class<?> clientClazz, Class<?> objectClazz) {
        for (Method method : clientClazz.getDeclaredMethods()) {
            if (method.getReturnType().equals(Void.TYPE) || !objectClazz.isAssignableFrom(method.getReturnType()) || !method.getName().startsWith("get")) continue;
            Class<?> cls = method.getReturnType();
            if (!map.containsKey(cls)) {
                map.put(cls, new CodecMethodRef());
            }
            CodecMethodRef builder = map.get(cls);
            if (method.getParameterTypes().length == 2 && Codec.class.isAssignableFrom(method.getParameterTypes()[1])) {
                builder.customCodecMethod = method;
                continue;
            }
            if (method.getParameterTypes().length != 1) continue;
            builder.defaultCodecMethod = method;
        }
    }

    public Object fromReference(RedissonReference rr, ReferenceType type) throws ReflectiveOperationException {
        if (type == ReferenceType.REACTIVE) {
            return this.fromReference(this.redissonReactive, rr);
        }
        if (type == ReferenceType.RXJAVA) {
            return this.fromReference(this.redissonRx, rr);
        }
        return this.fromReference(this.redisson, rr);
    }

    private Object fromReference(RedissonClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getType();
        if (type != null && ClassUtils.isAnnotationPresent(type, REntity.class)) {
            RedissonLiveObjectService liveObjectService = (RedissonLiveObjectService)redisson.getLiveObjectService();
            NamingScheme ns = this.getNamingScheme(type);
            Object id = ns.resolveId(rr.getKeyName());
            return liveObjectService.createLiveObject(type, id);
        }
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    private Object getObject(Object redisson, RedissonReference rr, Class<? extends Object> type, ReferenceCodecProvider codecProvider) throws ReflectiveOperationException {
        if (type != null) {
            CodecMethodRef b = REFERENCES.get(type);
            if (b == null && type.getInterfaces().length > 0) {
                type = type.getInterfaces()[0];
            }
            if ((b = REFERENCES.get(type)) != null) {
                Method builder = b.get(this.isDefaultCodec(rr));
                if (this.isDefaultCodec(rr)) {
                    return builder.invoke(redisson, rr.getKeyName());
                }
                return builder.invoke(redisson, rr.getKeyName(), codecProvider.getCodec(rr.getCodecType()));
            }
        }
        throw new ClassNotFoundException("No RObject is found to match class type of " + rr.getTypeName() + " with codec type of " + rr.getCodec());
    }

    private boolean isDefaultCodec(RedissonReference rr) {
        return rr.getCodec() == null;
    }

    private Object fromReference(RedissonRxClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getRxJavaType();
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    private Object fromReference(RedissonReactiveClient redisson, RedissonReference rr) throws ReflectiveOperationException {
        Class<?> type = rr.getReactiveType();
        return this.getObject(redisson, rr, type, this.codecProvider);
    }

    public RedissonReference toReference(Object object) {
        if (object != null && ClassUtils.isAnnotationPresent(object.getClass(), REntity.class)) {
            throw new IllegalArgumentException("REntity should be attached to Redisson before save");
        }
        if (object instanceof RObject && !(object instanceof RLiveObject)) {
            Class<?> clazz = object.getClass().getInterfaces()[0];
            RObject rObject = (RObject)object;
            if (rObject.getCodec() != null) {
                this.codecProvider.registerCodec(rObject.getCodec().getClass(), rObject.getCodec());
            }
            return new RedissonReference(clazz, rObject.getName(), rObject.getCodec());
        }
        if (object instanceof RObjectReactive && !(object instanceof RLiveObject)) {
            Class<?> clazz = object.getClass().getInterfaces()[0];
            RObjectReactive rObject = (RObjectReactive)object;
            if (rObject.getCodec() != null) {
                this.codecProvider.registerCodec(rObject.getCodec().getClass(), rObject.getCodec());
            }
            return new RedissonReference(clazz, rObject.getName(), rObject.getCodec());
        }
        if (object instanceof RObjectRx && !(object instanceof RLiveObject)) {
            Class<?> clazz = object.getClass().getInterfaces()[0];
            RObjectRx rObject = (RObjectRx)object;
            if (rObject.getCodec() != null) {
                this.codecProvider.registerCodec(rObject.getCodec().getClass(), rObject.getCodec());
            }
            return new RedissonReference(clazz, rObject.getName(), rObject.getCodec());
        }
        try {
            if (object instanceof RLiveObject) {
                Class<?> rEntity = object.getClass().getSuperclass();
                NamingScheme ns = this.getNamingScheme(rEntity);
                return new RedissonReference(rEntity, ns.getName(rEntity, ((RLiveObject)object).getLiveObjectId()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        return null;
    }

    private <T extends RObject, K extends Codec> T createRObject(RedissonClient redisson, Class<T> expectedType, String name, K codec) throws ReflectiveOperationException {
        Class<?>[] interfaces;
        for (Class<?> iType : interfaces = expectedType.getInterfaces()) {
            if (!REFERENCES.containsKey(iType)) continue;
            Method builder = REFERENCES.get(iType).get(codec != null);
            if (codec != null) {
                return (T)((RObject)builder.invoke((Object)redisson, name));
            }
            return (T)((RObject)builder.invoke((Object)redisson, name, codec));
        }
        String codecName = null;
        if (codec != null) {
            codecName = codec.getClass().getName();
        }
        throw new ClassNotFoundException("No RObject is found to match class type of " + expectedType.getName() + " with codec type of " + codecName);
    }

    public Object tryHandleReference(Object o, ReferenceType type) throws ReflectiveOperationException {
        boolean hasConversion = false;
        if (o instanceof List) {
            List r = (List)o;
            for (int i = 0; i < r.size(); ++i) {
                Object ref = this.tryHandleReference0(r.get(i), type);
                if (ref == r.get(i)) continue;
                r.set(i, ref);
            }
            return o;
        }
        if (o instanceof Set) {
            Set<Object> set;
            Set r = (Set)o;
            boolean useNewSet = o instanceof LinkedHashSet;
            try {
                set = (Set)o.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                set = new LinkedHashSet();
            }
            for (Object i : r) {
                Object ref = this.tryHandleReference0(i, type);
                if (useNewSet) {
                    set.add(ref);
                } else {
                    try {
                        r.add(ref);
                        set.add(i);
                    }
                    catch (Exception e) {
                        useNewSet = true;
                        set.add(ref);
                    }
                }
                hasConversion |= ref != i;
            }
            if (!hasConversion) {
                return o;
            }
            if (useNewSet) {
                return set;
            }
            if (!set.isEmpty()) {
                r.removeAll(set);
            }
            return o;
        }
        if (o instanceof Map) {
            Map r = (Map)o;
            for (Map.Entry e : r.entrySet()) {
                if (!(e.getKey() instanceof RedissonReference) && !(e.getValue() instanceof RedissonReference)) continue;
                Object key = e.getKey();
                Object value = e.getValue();
                if (e.getKey() instanceof RedissonReference) {
                    key = this.fromReference((RedissonReference)e.getKey(), type);
                    r.remove(e.getKey());
                }
                if (e.getValue() instanceof RedissonReference) {
                    value = this.fromReference((RedissonReference)e.getValue(), type);
                }
                r.put(key, value);
            }
            return o;
        }
        if (o instanceof ListScanResult) {
            this.tryHandleReference(((ListScanResult)o).getValues(), type);
            return o;
        }
        if (o instanceof MapScanResult) {
            MapScanResult scanResult = (MapScanResult)o;
            Map oldMap = ((MapScanResult)o).getMap();
            Map map = (Map)this.tryHandleReference(oldMap, type);
            if (map != oldMap) {
                MapScanResult newScanResult = new MapScanResult(scanResult.getPos(), map);
                newScanResult.setRedisClient(scanResult.getRedisClient());
                return newScanResult;
            }
            return o;
        }
        return this.tryHandleReference0(o, type);
    }

    private Object tryHandleReference0(Object o, ReferenceType type) throws ReflectiveOperationException {
        if (o instanceof RedissonReference) {
            return this.fromReference((RedissonReference)o, type);
        }
        if (o instanceof ScoredEntry && ((ScoredEntry)o).getValue() instanceof RedissonReference) {
            ScoredEntry se = (ScoredEntry)o;
            return new ScoredEntry<Object>(se.getScore(), this.fromReference((RedissonReference)se.getValue(), type));
        }
        if (o instanceof Map.Entry) {
            Map.Entry old = (Map.Entry)o;
            Object key = this.tryHandleReference0(old.getKey(), type);
            Object value = this.tryHandleReference0(old.getValue(), type);
            if (value != old.getValue() || key != old.getKey()) {
                return new AbstractMap.SimpleEntry<Object, Object>(key, value);
            }
        }
        return o;
    }

    static {
        SUPPORTED_CLASS_MAPPING.put(SortedSet.class, RedissonSortedSet.class);
        SUPPORTED_CLASS_MAPPING.put(Set.class, RedissonSet.class);
        SUPPORTED_CLASS_MAPPING.put(ConcurrentMap.class, RedissonMap.class);
        SUPPORTED_CLASS_MAPPING.put(Map.class, RedissonMap.class);
        SUPPORTED_CLASS_MAPPING.put(BlockingDeque.class, RedissonBlockingDeque.class);
        SUPPORTED_CLASS_MAPPING.put(Deque.class, RedissonDeque.class);
        SUPPORTED_CLASS_MAPPING.put(BlockingQueue.class, RedissonBlockingQueue.class);
        SUPPORTED_CLASS_MAPPING.put(Queue.class, RedissonQueue.class);
        SUPPORTED_CLASS_MAPPING.put(List.class, RedissonList.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonClient.class, RObject.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonReactiveClient.class, RObjectReactive.class);
        RedissonObjectBuilder.fillCodecMethods(REFERENCES, RedissonRxClient.class, RObjectRx.class);
    }

    public static class CodecMethodRef {
        Method defaultCodecMethod;
        Method customCodecMethod;

        Method get(boolean value) {
            if (value) {
                return this.defaultCodecMethod;
            }
            return this.customCodecMethod;
        }
    }

    public static enum ReferenceType {
        RXJAVA,
        REACTIVE,
        DEFAULT;

    }
}

