/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.Collections;
import java.util.List;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectListReplayDecoder<T>
implements MultiDecoder<List<T>> {
    private final Decoder<Object> decoder;
    private final boolean reverse;

    public ObjectListReplayDecoder() {
        this(false);
    }

    public ObjectListReplayDecoder(boolean reverse) {
        this(reverse, null);
    }

    public ObjectListReplayDecoder(boolean reverse, Decoder<Object> decoder) {
        this.reverse = reverse;
        this.decoder = decoder;
    }

    @Override
    public List<T> decode(List<Object> parts, State state) {
        if (this.reverse) {
            Collections.reverse(parts);
        }
        return parts;
    }

    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state) {
        if (this.decoder != null) {
            return this.decoder;
        }
        return MultiDecoder.super.getDecoder(codec, paramNum, state);
    }
}

