/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.redisson.SlotCallback;
import org.redisson.api.RBuckets;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.codec.CompositeCodec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.connection.decoder.BucketsDecoder;
import org.redisson.connection.decoder.MapGetAllDecoder;
import org.redisson.misc.RedissonPromise;

public class RedissonBuckets
implements RBuckets {
    protected final Codec codec;
    protected final CommandAsyncExecutor commandExecutor;

    public RedissonBuckets(CommandAsyncExecutor commandExecutor) {
        this(commandExecutor.getConnectionManager().getCodec(), commandExecutor);
    }

    public RedissonBuckets(Codec codec, CommandAsyncExecutor commandExecutor) {
        this.codec = codec;
        this.commandExecutor = commandExecutor;
    }

    @Override
    public <V> Map<String, V> get(String ... keys) {
        RFuture<Map<String, V>> future = this.getAsync(keys);
        return this.commandExecutor.get(future);
    }

    @Override
    public boolean trySet(Map<String, ?> buckets) {
        RFuture<Boolean> future = this.trySetAsync(buckets);
        return this.commandExecutor.get(future);
    }

    @Override
    public void set(Map<String, ?> buckets) {
        this.commandExecutor.get(this.setAsync(buckets));
    }

    @Override
    public <V> RFuture<Map<String, V>> getAsync(String ... keys) {
        if (keys.length == 0) {
            return RedissonPromise.newSucceededFuture(Collections.emptyMap());
        }
        CompositeCodec commandCodec = new CompositeCodec(StringCodec.INSTANCE, this.codec, this.codec);
        RedisCommand<Map<Object, Object>> command = new RedisCommand<Map<Object, Object>>("MGET", new MapGetAllDecoder(Arrays.asList(keys), 0));
        return this.commandExecutor.readBatchedAsync(commandCodec, command, new SlotCallback<Map<Object, Object>, Map<String, V>>(){
            Map<String, V> results = new ConcurrentHashMap();

            @Override
            public void onSlotResult(Map<Object, Object> result) {
                for (Map.Entry<Object, Object> entry : result.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    this.results.put((String)entry.getKey(), entry.getValue());
                }
            }

            @Override
            public Map<String, V> onFinish() {
                return this.results;
            }

            @Override
            public RedisCommand<Map<Object, Object>> createCommand(Object param) {
                return new RedisCommand<Map<Object, Object>>("MGET", new BucketsDecoder(param.toString()));
            }
        }, keys);
    }

    @Override
    public RFuture<Boolean> trySetAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(false);
        }
        ArrayList<Object> params = new ArrayList<Object>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add(this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.commandExecutor.writeAsync(params.get(0).toString(), RedisCommands.MSETNX, params.toArray());
    }

    @Override
    public RFuture<Void> setAsync(Map<String, ?> buckets) {
        if (buckets.isEmpty()) {
            return RedissonPromise.newSucceededFuture(null);
        }
        ArrayList<Object> params = new ArrayList<Object>(buckets.size());
        for (Map.Entry<String, ?> entry : buckets.entrySet()) {
            params.add(entry.getKey());
            try {
                params.add(this.codec.getValueEncoder().encode(entry.getValue()));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return this.commandExecutor.writeAsync(params.get(0).toString(), RedisCommands.MSET, params.toArray());
    }
}

