/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.BiFunction;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableScan<T>
extends AbstractFlowableWithUpstream<T, T> {
    final BiFunction<T, T, T> accumulator;

    public FlowableScan(Flowable<T> source, BiFunction<T, T, T> accumulator) {
        super(source);
        this.accumulator = accumulator;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> s) {
        this.source.subscribe(new ScanSubscriber<T>(s, this.accumulator));
    }

    static final class ScanSubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final BiFunction<T, T, T> accumulator;
        Subscription upstream;
        T value;
        boolean done;

        ScanSubscriber(Subscriber<? super T> actual, BiFunction<T, T, T> accumulator) {
            this.downstream = actual;
            this.accumulator = accumulator;
        }

        @Override
        public void onSubscribe(Subscription s) {
            if (SubscriptionHelper.validate(this.upstream, s)) {
                this.upstream = s;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t) {
            if (this.done) {
                return;
            }
            Subscriber<T> a = this.downstream;
            T v = this.value;
            if (v == null) {
                this.value = t;
                a.onNext(t);
            } else {
                T u;
                try {
                    u = Objects.requireNonNull(this.accumulator.apply(v, t), "The value returned by the accumulator is null");
                }
                catch (Throwable e) {
                    Exceptions.throwIfFatal(e);
                    this.upstream.cancel();
                    this.onError(e);
                    return;
                }
                this.value = u;
                a.onNext(u);
            }
        }

        @Override
        public void onError(Throwable t) {
            if (this.done) {
                RxJavaPlugins.onError(t);
                return;
            }
            this.done = true;
            this.downstream.onError(t);
        }

        @Override
        public void onComplete() {
            if (this.done) {
                return;
            }
            this.done = true;
            this.downstream.onComplete();
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
        }
    }
}

