/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction;

import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.redisson.RedissonBucket;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.client.codec.Codec;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.DeleteOperation;
import org.redisson.transaction.operation.TouchOperation;
import org.redisson.transaction.operation.TransactionalOperation;
import org.redisson.transaction.operation.UnlinkOperation;
import org.redisson.transaction.operation.bucket.BucketCompareAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndDeleteOperation;
import org.redisson.transaction.operation.bucket.BucketGetAndSetOperation;
import org.redisson.transaction.operation.bucket.BucketSetOperation;
import org.redisson.transaction.operation.bucket.BucketTrySetOperation;

public class RedissonTransactionalBucket<V>
extends RedissonBucket<V> {
    static final Object NULL = new Object();
    private long timeout;
    private final AtomicBoolean executed;
    private final List<TransactionalOperation> operations;
    private Object state;
    private final String transactionId;

    public RedissonTransactionalBucket(CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    public RedissonTransactionalBucket(Codec codec, CommandAsyncExecutor commandExecutor, long timeout, String name, List<TransactionalOperation> operations, AtomicBoolean executed, String transactionId) {
        super(codec, commandExecutor, name);
        this.operations = operations;
        this.executed = executed;
        this.transactionId = transactionId;
        this.timeout = timeout;
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> expireAsync(Instant timestamp) {
        throw new UnsupportedOperationException("expire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        throw new UnsupportedOperationException("clearExpire method is not supported in transaction");
    }

    @Override
    public RFuture<Boolean> moveAsync(int database) {
        throw new UnsupportedOperationException("moveAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        throw new UnsupportedOperationException("migrateAsync method is not supported in transaction");
    }

    @Override
    public RFuture<Long> sizeAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(0L);
            }
            ByteBuf buf = this.encode(this.state);
            long size = buf.readableBytes();
            buf.release();
            return RedissonPromise.newSucceededFuture(size);
        }
        return super.sizeAsync();
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            return RedissonPromise.newSucceededFuture(true);
        }
        return super.isExistsAsync();
    }

    @Override
    public RFuture<Boolean> touchAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new TouchOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    result.trySuccess(RedissonTransactionalBucket.this.state != NULL);
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.operations.add(new TouchOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Boolean> unlinkAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new UnlinkOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        result.trySuccess(false);
                    } else {
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(true);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.operations.add(new UnlinkOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName()));
                    RedissonTransactionalBucket.this.state = NULL;
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        final long threadId = Thread.currentThread().getId();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new DeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.transactionId, threadId));
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        result.trySuccess(false);
                    } else {
                        RedissonTransactionalBucket.this.state = NULL;
                        result.trySuccess(true);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.isExistsAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.operations.add(new DeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.transactionId, threadId));
                    RedissonTransactionalBucket.this.state = NULL;
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAsync() {
        this.checkState();
        if (this.state != null) {
            if (this.state == NULL) {
                return RedissonPromise.newSucceededFuture(null);
            }
            return RedissonPromise.newSucceededFuture(this.state);
        }
        return super.getAsync();
    }

    @Override
    public RFuture<Boolean> compareAndSetAsync(final V expect, final V update) {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(new BucketCompareAndSetOperation<Object>(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), expect, update, RedissonTransactionalBucket.this.transactionId));
                    if (RedissonTransactionalBucket.this.state == NULL && expect == null || RedissonTransactionalBucket.this.isEquals(RedissonTransactionalBucket.this.state, expect)) {
                        if (update == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = update;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.operations.add(new BucketCompareAndSetOperation<Object>(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), expect, update, RedissonTransactionalBucket.this.transactionId));
                    if (res == null && expect == null || RedissonTransactionalBucket.this.isEquals(res, expect)) {
                        if (update == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = update;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAndSetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId));
    }

    @Override
    public RFuture<V> getAndSetAsync(V value) {
        return this.getAndSet(value, new BucketGetAndSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, this.transactionId));
    }

    private RFuture<V> getAndSet(final V newValue, final TransactionalOperation operation) {
        this.checkState();
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    Object prevValue = RedissonTransactionalBucket.this.state == NULL ? null : RedissonTransactionalBucket.this.state;
                    RedissonTransactionalBucket.this.operations.add(operation);
                    if (newValue == null) {
                        RedissonTransactionalBucket.this.state = NULL;
                    } else {
                        RedissonTransactionalBucket.this.state = newValue;
                    }
                    result.trySuccess(prevValue);
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    if (newValue == null) {
                        RedissonTransactionalBucket.this.state = NULL;
                    } else {
                        RedissonTransactionalBucket.this.state = newValue;
                    }
                    RedissonTransactionalBucket.this.operations.add(operation);
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<V> getAndDeleteAsync() {
        this.checkState();
        final RedissonPromise result = new RedissonPromise();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    Object prevValue = RedissonTransactionalBucket.this.state == NULL ? null : RedissonTransactionalBucket.this.state;
                    RedissonTransactionalBucket.this.operations.add(new BucketGetAndDeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), RedissonTransactionalBucket.this.transactionId));
                    RedissonTransactionalBucket.this.state = NULL;
                    result.trySuccess(prevValue);
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.state = NULL;
                    RedissonTransactionalBucket.this.operations.add(new BucketGetAndDeleteOperation(RedissonTransactionalBucket.this.getName(), RedissonTransactionalBucket.this.getLockName(), RedissonTransactionalBucket.this.getCodec(), RedissonTransactionalBucket.this.transactionId));
                    result.trySuccess(res);
                });
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> setAsync(V newValue) {
        return this.setAsync(newValue, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue, this.transactionId));
    }

    private RFuture<Void> setAsync(final V newValue, final TransactionalOperation operation) {
        this.checkState();
        final RedissonPromise<Void> result = new RedissonPromise<Void>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                RedissonTransactionalBucket.this.operations.add(operation);
                if (newValue == null) {
                    RedissonTransactionalBucket.this.state = NULL;
                } else {
                    RedissonTransactionalBucket.this.state = newValue;
                }
                result.trySuccess(null);
            }
        });
        return result;
    }

    @Override
    public RFuture<Void> setAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.setAsync(value, new BucketSetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V newValue) {
        return this.trySet(newValue, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), newValue, this.transactionId));
    }

    @Override
    public RFuture<Boolean> trySetAsync(V value, long timeToLive, TimeUnit timeUnit) {
        return this.trySet(value, new BucketTrySetOperation(this.getName(), this.getLockName(), this.getCodec(), value, timeToLive, timeUnit, this.transactionId));
    }

    private RFuture<Boolean> trySet(final V newValue, final TransactionalOperation operation) {
        this.checkState();
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        this.executeLocked(result, new Runnable(){

            @Override
            public void run() {
                if (RedissonTransactionalBucket.this.state != null) {
                    RedissonTransactionalBucket.this.operations.add(operation);
                    if (RedissonTransactionalBucket.this.state == NULL) {
                        if (newValue == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = newValue;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                    return;
                }
                RedissonTransactionalBucket.this.getAsync().onComplete((res, e) -> {
                    if (e != null) {
                        result.tryFailure((Throwable)e);
                        return;
                    }
                    RedissonTransactionalBucket.this.operations.add(operation);
                    if (res == null) {
                        if (newValue == null) {
                            RedissonTransactionalBucket.this.state = NULL;
                        } else {
                            RedissonTransactionalBucket.this.state = newValue;
                        }
                        result.trySuccess(true);
                    } else {
                        result.trySuccess(false);
                    }
                });
            }
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEquals(Object value, Object oldValue) {
        ByteBuf valueBuf = this.encode(value);
        ByteBuf oldValueBuf = this.encode(oldValue);
        try {
            boolean bl = valueBuf.equals(oldValueBuf);
            return bl;
        }
        finally {
            valueBuf.readableBytes();
            oldValueBuf.readableBytes();
        }
    }

    protected <R> void executeLocked(RPromise<R> promise, Runnable runnable) {
        RLock lock = this.getLock();
        lock.lockAsync(this.timeout, TimeUnit.MILLISECONDS).onComplete((res, e) -> {
            if (e == null) {
                runnable.run();
            } else {
                promise.tryFailure((Throwable)e);
            }
        });
    }

    private RLock getLock() {
        return new RedissonTransactionalLock(this.commandExecutor, this.getLockName(), this.transactionId);
    }

    private String getLockName() {
        return this.getName() + ":transaction_lock";
    }

    protected void checkState() {
        if (this.executed.get()) {
            throw new IllegalStateException("Unable to execute operation. Transaction is in finished state!");
        }
    }
}

