/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.redisnode;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.redisnode.RedisNode;
import org.redisson.api.redisnode.RedisSentinel;
import org.redisson.api.redisnode.RedisSentinelAsync;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.Time;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RedissonPromise;

public class SentinelRedisNode
implements RedisSentinel,
RedisSentinelAsync {
    private final RedisClient client;
    private final CommandAsyncExecutor commandAsyncService;

    public SentinelRedisNode(RedisClient client, CommandAsyncExecutor commandAsyncService) {
        this.client = client;
        this.commandAsyncService = commandAsyncService;
    }

    public RedisClient getClient() {
        return this.client;
    }

    @Override
    public InetSocketAddress getAddr() {
        return this.client.getAddr();
    }

    @Override
    public Map<String, String> getMemoryStatistics() {
        return this.getMemoryStatisticsAsync().syncUninterruptibly().getNow();
    }

    @Override
    public RFuture<Map<String, String>> getMemoryStatisticsAsync() {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.MEMORY_STATS, new Object[0]);
    }

    @Override
    public RFuture<Boolean> pingAsync() {
        return this.pingAsync(1L, TimeUnit.SECONDS);
    }

    @Override
    public RFuture<Boolean> pingAsync(long timeout, TimeUnit timeUnit) {
        return this.executeAsync(false, null, timeUnit.toMillis(timeout), RedisCommands.PING_BOOL, new Object[0]);
    }

    @Override
    public boolean ping() {
        return this.pingAsync().syncUninterruptibly().getNow();
    }

    @Override
    public boolean ping(long timeout, TimeUnit timeUnit) {
        return this.pingAsync(timeout, timeUnit).syncUninterruptibly().getNow();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client == null ? 0 : this.client.getAddr().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SentinelRedisNode other = (SentinelRedisNode)obj;
        return !(this.client == null ? other.client != null : !this.client.getAddr().equals(other.client.getAddr()));
    }

    private <T> RFuture<T> executeAsync(T defaultValue, Codec codec, long timeout, RedisCommand<T> command, Object ... params) {
        RedissonPromise result = new RedissonPromise();
        RFuture<RedisConnection> connectionFuture = this.client.connectAsync();
        connectionFuture.onComplete((connection, ex) -> {
            if (ex != null) {
                if (defaultValue != null) {
                    result.trySuccess(defaultValue);
                } else {
                    result.tryFailure((Throwable)ex);
                }
                return;
            }
            RFuture future = connection.async(timeout, codec, command, params);
            future.onComplete((r, e) -> {
                connection.closeAsync();
                if (e != null) {
                    if (defaultValue != null) {
                        result.trySuccess(defaultValue);
                    } else {
                        result.tryFailure((Throwable)e);
                    }
                    return;
                }
                result.trySuccess(r);
            });
        });
        return result;
    }

    @Override
    public RFuture<Time> timeAsync() {
        return this.executeAsync(null, LongCodec.INSTANCE, -1L, RedisCommands.TIME, new Object[0]);
    }

    @Override
    public Time time() {
        return this.timeAsync().syncUninterruptibly().getNow();
    }

    public String toString() {
        return this.getClass().toString() + " [client=" + this.client + "]";
    }

    @Override
    public Map<String, String> info(RedisNode.InfoSection section) {
        return this.infoAsync(section).syncUninterruptibly().getNow();
    }

    @Override
    public RFuture<Map<String, String>> infoAsync(RedisNode.InfoSection section) {
        if (section == RedisNode.InfoSection.ALL) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_ALL, new Object[0]);
        }
        if (section == RedisNode.InfoSection.DEFAULT) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_DEFAULT, new Object[0]);
        }
        if (section == RedisNode.InfoSection.SERVER) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_SERVER, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CLIENTS) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_CLIENTS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.MEMORY) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_MEMORY, new Object[0]);
        }
        if (section == RedisNode.InfoSection.PERSISTENCE) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_PERSISTENCE, new Object[0]);
        }
        if (section == RedisNode.InfoSection.STATS) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_STATS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.REPLICATION) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_REPLICATION, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CPU) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_CPU, new Object[0]);
        }
        if (section == RedisNode.InfoSection.COMMANDSTATS) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_COMMANDSTATS, new Object[0]);
        }
        if (section == RedisNode.InfoSection.CLUSTER) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_CLUSTER, new Object[0]);
        }
        if (section == RedisNode.InfoSection.KEYSPACE) {
            return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.INFO_KEYSPACE, new Object[0]);
        }
        throw new IllegalStateException();
    }

    @Override
    public InetSocketAddress getMasterAddr(String masterName) {
        return this.commandAsyncService.get(this.getMasterAddrAsync(masterName));
    }

    @Override
    public List<Map<String, String>> getSentinels(String masterName) {
        return this.commandAsyncService.get(this.getSentinelsAsync(masterName));
    }

    @Override
    public List<Map<String, String>> getMasters() {
        return this.commandAsyncService.get(this.getMastersAsync());
    }

    @Override
    public List<Map<String, String>> getSlaves(String masterName) {
        return this.commandAsyncService.get(this.getSlavesAsync(masterName));
    }

    @Override
    public Map<String, String> getMaster(String masterName) {
        return this.commandAsyncService.get(this.getMasterAsync(masterName));
    }

    @Override
    public void failover(String masterName) {
        this.commandAsyncService.get(this.failoverAsync(masterName));
    }

    @Override
    public RFuture<InetSocketAddress> getMasterAddrAsync(String masterName) {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.SENTINEL_GET_MASTER_ADDR_BY_NAME, masterName);
    }

    @Override
    public RFuture<List<Map<String, String>>> getSentinelsAsync(String masterName) {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.SENTINEL_SENTINELS, masterName);
    }

    @Override
    public RFuture<List<Map<String, String>>> getMastersAsync() {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.SENTINEL_MASTERS, new Object[0]);
    }

    @Override
    public RFuture<List<Map<String, String>>> getSlavesAsync(String masterName) {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.SENTINEL_SLAVES, masterName);
    }

    @Override
    public RFuture<Map<String, String>> getMasterAsync(String masterName) {
        return this.executeAsync(null, null, -1L, RedisCommands.SENTINEL_MASTER, masterName);
    }

    @Override
    public RFuture<Void> failoverAsync(String masterName) {
        return this.executeAsync(null, null, -1L, RedisCommands.SENTINEL_FAILOVER, masterName);
    }

    @Override
    public Map<String, String> getConfig(String parameter) {
        return this.getConfigAsync(parameter).syncUninterruptibly().getNow();
    }

    @Override
    public void setConfig(String parameter, String value) {
        this.setConfigAsync(parameter, value).syncUninterruptibly().getNow();
    }

    @Override
    public RFuture<Map<String, String>> getConfigAsync(String parameter) {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.CONFIG_GET_MAP, parameter);
    }

    @Override
    public RFuture<Void> setConfigAsync(String parameter, String value) {
        return this.executeAsync(null, StringCodec.INSTANCE, -1L, RedisCommands.CONFIG_SET, parameter, value);
    }
}

