/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.reactive;

import java.util.concurrent.Callable;
import org.redisson.api.BatchOptions;
import org.redisson.api.BatchResult;
import org.redisson.api.RFuture;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.command.CommandBatchService;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.NodeSource;
import org.redisson.liveobject.core.RedissonObjectBuilder;
import org.redisson.misc.RPromise;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.reactive.CommandReactiveService;
import reactor.core.publisher.Mono;

public class CommandReactiveBatchService
extends CommandReactiveService {
    private final CommandBatchService batchService;

    public CommandReactiveBatchService(ConnectionManager connectionManager, CommandReactiveExecutor commandExecutor, BatchOptions options) {
        super(connectionManager, commandExecutor.getObjectBuilder());
        this.batchService = new CommandBatchService(commandExecutor, options, RedissonObjectBuilder.ReferenceType.REACTIVE);
    }

    @Override
    public <R> Mono<R> reactive(final Callable<RFuture<R>> supplier) {
        Mono mono = super.reactive(new Callable<RFuture<R>>(){
            volatile RFuture<R> future;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public RFuture<R> call() throws Exception {
                if (this.future == null) {
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        if (this.future == null) {
                            this.future = (RFuture)supplier.call();
                        }
                    }
                }
                return this.future;
            }
        });
        mono.subscribe();
        return mono;
    }

    @Override
    protected <R> RPromise<R> createPromise() {
        return this.batchService.createPromise();
    }

    @Override
    public <V, R> void async(boolean readOnlyMode, NodeSource nodeSource, Codec codec, RedisCommand<V> command, Object[] params, RPromise<R> mainPromise, boolean ignoreRedirect) {
        this.batchService.async(readOnlyMode, nodeSource, codec, command, params, mainPromise, ignoreRedirect);
    }

    public RFuture<BatchResult<?>> executeAsync() {
        return this.batchService.executeAsync();
    }
}

