/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.redisson.api.HostPortNatMapper;
import org.redisson.api.NatMapper;
import org.redisson.config.BaseMasterSlaveServersConfig;

public class SentinelServersConfig
extends BaseMasterSlaveServersConfig<SentinelServersConfig> {
    private List<String> sentinelAddresses = new ArrayList<String>();
    private NatMapper natMapper = NatMapper.direct();
    private String masterName;
    private String sentinelPassword;
    private int database = 0;
    private int scanInterval = 1000;
    private boolean checkSentinelsList = true;
    private boolean checkSlaveStatusWithSyncing = true;

    public SentinelServersConfig() {
    }

    SentinelServersConfig(SentinelServersConfig config) {
        super(config);
        this.setSentinelAddresses(config.getSentinelAddresses());
        this.setMasterName(config.getMasterName());
        this.setDatabase(config.getDatabase());
        this.setScanInterval(config.getScanInterval());
        this.setNatMapper(config.getNatMapper());
        this.setCheckSentinelsList(config.isCheckSentinelsList());
        this.setSentinelPassword(config.getSentinelPassword());
        this.setCheckSlaveStatusWithSyncing(config.isCheckSlaveStatusWithSyncing());
    }

    public SentinelServersConfig setMasterName(String masterName) {
        this.masterName = masterName;
        return this;
    }

    public String getMasterName() {
        return this.masterName;
    }

    public SentinelServersConfig setSentinelPassword(String sentinelPassword) {
        this.sentinelPassword = sentinelPassword;
        return this;
    }

    public String getSentinelPassword() {
        return this.sentinelPassword;
    }

    public SentinelServersConfig addSentinelAddress(String ... addresses) {
        this.sentinelAddresses.addAll(Arrays.asList(addresses));
        return this;
    }

    public List<String> getSentinelAddresses() {
        return this.sentinelAddresses;
    }

    void setSentinelAddresses(List<String> sentinelAddresses) {
        this.sentinelAddresses = sentinelAddresses;
    }

    public SentinelServersConfig setDatabase(int database) {
        this.database = database;
        return this;
    }

    public int getDatabase() {
        return this.database;
    }

    public int getScanInterval() {
        return this.scanInterval;
    }

    public SentinelServersConfig setScanInterval(int scanInterval) {
        this.scanInterval = scanInterval;
        return this;
    }

    @Deprecated
    public SentinelServersConfig setNatMap(Map<String, String> natMap) {
        HostPortNatMapper mapper = new HostPortNatMapper();
        mapper.setHostsPortMap(natMap);
        this.natMapper = mapper;
        return this;
    }

    public NatMapper getNatMapper() {
        return this.natMapper;
    }

    public SentinelServersConfig setNatMapper(NatMapper natMapper) {
        this.natMapper = natMapper;
        return this;
    }

    public boolean isCheckSentinelsList() {
        return this.checkSentinelsList;
    }

    public SentinelServersConfig setCheckSentinelsList(boolean checkSentinelsList) {
        this.checkSentinelsList = checkSentinelsList;
        return this;
    }

    public boolean isCheckSlaveStatusWithSyncing() {
        return this.checkSlaveStatusWithSyncing;
    }

    public SentinelServersConfig setCheckSlaveStatusWithSyncing(boolean checkSlaveStatusWithSyncing) {
        this.checkSlaveStatusWithSyncing = checkSlaveStatusWithSyncing;
        return this;
    }
}

