/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonBitSet;
import org.redisson.RedissonExpirable;
import org.redisson.api.RBitSetAsync;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RFuture;
import org.redisson.client.RedisException;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.DoubleCodec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.convertor.VoidReplayConvertor;
import org.redisson.client.protocol.decoder.ObjectMapReplayDecoder;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.command.CommandBatchService;
import org.redisson.misc.Hash;

public class RedissonBloomFilter<T>
extends RedissonExpirable
implements RBloomFilter<T> {
    private volatile long size;
    private volatile int hashIterations;
    private final CommandAsyncExecutor commandExecutor;
    private String configName;

    protected RedissonBloomFilter(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.configName = RedissonBloomFilter.suffixName(this.getName(), "config");
    }

    protected RedissonBloomFilter(Codec codec, CommandAsyncExecutor commandExecutor, String name) {
        super(codec, commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.configName = RedissonBloomFilter.suffixName(this.getName(), "config");
    }

    private int optimalNumOfHashFunctions(long n, long m) {
        return Math.max(1, (int)Math.round((double)m / (double)n * Math.log(2.0)));
    }

    private long optimalNumOfBits(long n, double p) {
        if (p == 0.0) {
            p = Double.MIN_VALUE;
        }
        return (long)((double)(-n) * Math.log(p) / (Math.log(2.0) * Math.log(2.0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] hash(Object object) {
        ByteBuf state = this.encode(object);
        try {
            long[] lArray = Hash.hash128(state);
            return lArray;
        }
        finally {
            state.release();
        }
    }

    @Override
    public boolean add(T object) {
        long[] hashes = this.hash(object);
        while (true) {
            if (this.size == 0L) {
                this.readConfig();
            }
            int hashIterations = this.hashIterations;
            long size = this.size;
            long[] indexes = this.hash(hashes[0], hashes[1], hashIterations, size);
            CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
            this.addConfigCheck(hashIterations, size, executorService);
            RBitSetAsync bs = this.createBitSet(executorService);
            for (int i = 0; i < indexes.length; ++i) {
                bs.setAsync(indexes[i]);
            }
            try {
                List<?> result = executorService.execute().getResponses();
                for (Boolean val : result.subList(1, result.size() - 1)) {
                    if (val.booleanValue()) continue;
                    return true;
                }
                return false;
            }
            catch (RedisException e) {
                if (e.getMessage() != null && e.getMessage().contains("Bloom filter config has been changed")) continue;
                throw e;
            }
            break;
        }
    }

    private long[] hash(long hash1, long hash2, int iterations, long size) {
        long[] indexes = new long[iterations];
        long hash = hash1;
        for (int i = 0; i < iterations; ++i) {
            indexes[i] = (hash & Long.MAX_VALUE) % size;
            if (i % 2 == 0) {
                hash += hash2;
                continue;
            }
            hash += hash1;
        }
        return indexes;
    }

    @Override
    public boolean contains(T object) {
        long[] hashes = this.hash(object);
        while (true) {
            if (this.size == 0L) {
                this.readConfig();
            }
            int hashIterations = this.hashIterations;
            long size = this.size;
            long[] indexes = this.hash(hashes[0], hashes[1], hashIterations, size);
            CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
            this.addConfigCheck(hashIterations, size, executorService);
            RBitSetAsync bs = this.createBitSet(executorService);
            for (int i = 0; i < indexes.length; ++i) {
                bs.getAsync(indexes[i]);
            }
            try {
                List<?> result = executorService.execute().getResponses();
                for (Boolean val : result.subList(1, result.size() - 1)) {
                    if (val.booleanValue()) continue;
                    return false;
                }
                return true;
            }
            catch (RedisException e) {
                if (e.getMessage() != null && e.getMessage().contains("Bloom filter config has been changed")) continue;
                throw e;
            }
            break;
        }
    }

    protected RBitSetAsync createBitSet(CommandBatchService executorService) {
        return new RedissonBitSet(executorService, this.getName());
    }

    private void addConfigCheck(int hashIterations, long size, CommandBatchService executorService) {
        executorService.evalReadAsync(this.configName, this.codec, RedisCommands.EVAL_VOID, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == ARGV[1] and hashIterations == ARGV[2], 'Bloom filter config has been changed')", Arrays.asList(this.configName), size, hashIterations);
    }

    @Override
    public long count() {
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
        RFuture configFuture = executorService.readAsync(this.configName, (Codec)StringCodec.INSTANCE, new RedisCommand("HGETALL", new ObjectMapReplayDecoder()), this.configName);
        RBitSetAsync bs = this.createBitSet(executorService);
        RFuture<Long> cardinalityFuture = bs.cardinalityAsync();
        executorService.execute();
        this.readConfig((Map)configFuture.getNow());
        return Math.round((double)(-this.size) / (double)this.hashIterations * Math.log(1.0 - (double)cardinalityFuture.getNow().longValue() / (double)this.size));
    }

    @Override
    public RFuture<Boolean> deleteAsync() {
        return this.deleteAsync(this.getName(), this.configName);
    }

    @Override
    public RFuture<Long> sizeInMemoryAsync() {
        List<Object> keys = Arrays.asList(this.getName(), this.configName);
        return super.sizeInMemoryAsync(keys);
    }

    private void readConfig() {
        RFuture future = this.commandExecutor.readAsync(this.configName, (Codec)StringCodec.INSTANCE, new RedisCommand("HGETALL", new ObjectMapReplayDecoder()), this.configName);
        Map config = (Map)this.commandExecutor.get(future);
        this.readConfig(config);
    }

    private void readConfig(Map<String, String> config) {
        if (config.get("hashIterations") == null || config.get("size") == null) {
            throw new IllegalStateException("Bloom filter is not initialized!");
        }
        this.size = Long.valueOf(config.get("size"));
        this.hashIterations = Integer.valueOf(config.get("hashIterations"));
    }

    protected long getMaxSize() {
        return 0xFFFFFFFEL;
    }

    @Override
    public boolean tryInit(long expectedInsertions, double falseProbability) {
        if (falseProbability > 1.0) {
            throw new IllegalArgumentException("Bloom filter false probability can't be greater than 1");
        }
        if (falseProbability < 0.0) {
            throw new IllegalArgumentException("Bloom filter false probability can't be negative");
        }
        this.size = this.optimalNumOfBits(expectedInsertions, falseProbability);
        if (this.size == 0L) {
            throw new IllegalArgumentException("Bloom filter calculated size is " + this.size);
        }
        if (this.size > this.getMaxSize()) {
            throw new IllegalArgumentException("Bloom filter size can't be greater than " + this.getMaxSize() + ". But calculated size is " + this.size);
        }
        this.hashIterations = this.optimalNumOfHashFunctions(expectedInsertions, this.size);
        CommandBatchService executorService = new CommandBatchService(this.commandExecutor);
        executorService.evalReadAsync(this.configName, this.codec, RedisCommands.EVAL_VOID, "local size = redis.call('hget', KEYS[1], 'size');local hashIterations = redis.call('hget', KEYS[1], 'hashIterations');assert(size == false and hashIterations == false, 'Bloom filter config has been changed')", Arrays.asList(this.configName), this.size, this.hashIterations);
        executorService.writeAsync(this.configName, (Codec)StringCodec.INSTANCE, new RedisCommand<Void>("HMSET", new VoidReplayConvertor()), this.configName, "size", this.size, "hashIterations", this.hashIterations, "expectedInsertions", expectedInsertions, "falseProbability", BigDecimal.valueOf(falseProbability).toPlainString());
        try {
            executorService.execute();
        }
        catch (RedisException e) {
            if (e.getMessage() == null || !e.getMessage().contains("Bloom filter config has been changed")) {
                throw e;
            }
            this.readConfig();
            return false;
        }
        return true;
    }

    @Override
    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        return this.expireAsync(timeToLive, timeUnit, this.getName(), this.configName);
    }

    @Override
    public RFuture<Boolean> expireAtAsync(long timestamp) {
        return this.expireAtAsync(timestamp, this.getName(), this.configName);
    }

    @Override
    public RFuture<Boolean> clearExpireAsync() {
        return this.clearExpireAsync(this.getName(), this.configName);
    }

    @Override
    public long getExpectedInsertions() {
        Long result = (Long)this.get(this.commandExecutor.readAsync(this.configName, (Codec)LongCodec.INSTANCE, RedisCommands.HGET, this.configName, "expectedInsertions"));
        return this.check(result);
    }

    @Override
    public double getFalseProbability() {
        Double result = (Double)this.get(this.commandExecutor.readAsync(this.configName, (Codec)DoubleCodec.INSTANCE, RedisCommands.HGET, this.configName, "falseProbability"));
        return this.check(result);
    }

    @Override
    public long getSize() {
        Long result = (Long)this.get(this.commandExecutor.readAsync(this.configName, (Codec)LongCodec.INSTANCE, RedisCommands.HGET, this.configName, "size"));
        return this.check(result);
    }

    @Override
    public int getHashIterations() {
        Integer result = (Integer)this.get(this.commandExecutor.readAsync(this.configName, (Codec)IntegerCodec.INSTANCE, RedisCommands.HGET, this.configName, "hashIterations"));
        return this.check(result);
    }

    @Override
    public RFuture<Boolean> isExistsAsync() {
        return this.commandExecutor.writeAsync(this.getName(), this.codec, RedisCommands.EXISTS, this.getName(), this.configName);
    }

    @Override
    public RFuture<Void> renameAsync(String newName) {
        String newConfigName = RedissonBloomFilter.suffixName(newName, "config");
        RFuture<Void> f = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "if redis.call('exists', KEYS[1]) == 1 then redis.call('rename', KEYS[1], ARGV[1]); end; return redis.call('rename', KEYS[2], ARGV[2]); ", Arrays.asList(this.getName(), this.configName), newName, newConfigName);
        f.onComplete((value, e) -> {
            if (e == null) {
                this.setName(newName);
                this.configName = newConfigName;
            }
        });
        return f;
    }

    @Override
    public RFuture<Boolean> renamenxAsync(String newName) {
        String newConfigName = RedissonBloomFilter.suffixName(newName, "config");
        RFuture<Boolean> f = this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local r = redis.call('renamenx', KEYS[1], ARGV[1]); if r == 0 then   return 0; else    return redis.call('renamenx', KEYS[2], ARGV[2]); end; ", Arrays.asList(this.getName(), this.configName), newName, newConfigName);
        f.onComplete((value, e) -> {
            if (e == null && value.booleanValue()) {
                this.setName(newName);
                this.configName = newConfigName;
            }
        });
        return f;
    }

    private <V> V check(V result) {
        if (result == null) {
            throw new IllegalStateException("Bloom filter is not initialized!");
        }
        return result;
    }
}

