/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.transaction.operation.map;

import org.redisson.RedissonMap;
import org.redisson.RedissonMapCache;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.transaction.RedissonTransactionalLock;
import org.redisson.transaction.operation.TransactionalOperation;

public abstract class MapOperation
extends TransactionalOperation {
    Object key;
    Object value;
    Object oldValue;
    RMap<?, ?> map;
    String transactionId;
    long threadId;

    public MapOperation() {
    }

    public MapOperation(RMap<?, ?> map, Object key, Object value, String transactionId, long threadId) {
        this(map, key, value, null, transactionId, threadId);
    }

    public MapOperation(RMap<?, ?> map, Object key, Object value, Object oldValue, String transactionId, long threadId) {
        super(map.getName(), map.getCodec());
        this.map = map;
        this.key = key;
        this.value = value;
        this.oldValue = oldValue;
        this.transactionId = transactionId;
        this.threadId = threadId;
    }

    public Object getKey() {
        return this.key;
    }

    public RMap<?, ?> getMap() {
        return this.map;
    }

    @Override
    public final void commit(CommandAsyncExecutor commandExecutor) {
        RMap<Object, Object> map = this.getMap(commandExecutor);
        this.commit(map);
        this.getLock(map, commandExecutor, this.key).unlockAsync(this.threadId);
    }

    protected RMap<Object, Object> getMap(CommandAsyncExecutor commandExecutor) {
        if (this.map instanceof RMapCache) {
            return new RedissonMapCache<Object, Object>(this.codec, null, commandExecutor, this.name, null, null, null);
        }
        return new RedissonMap<Object, Object>(this.codec, commandExecutor, this.name, null, null, null);
    }

    @Override
    public void rollback(CommandAsyncExecutor commandExecutor) {
        RMap<Object, Object> map = this.getMap(commandExecutor);
        this.getLock(map, commandExecutor, this.key).unlockAsync(this.threadId);
    }

    protected RLock getLock(RMap<?, ?> map, CommandAsyncExecutor commandExecutor, Object key) {
        String lockName = ((RedissonMap)map).getLockByMapKey(key, "lock");
        return new RedissonTransactionalLock(commandExecutor, lockName, this.transactionId);
    }

    protected abstract void commit(RMap<Object, Object> var1);

    public Object getValue() {
        return this.value;
    }

    public Object getOldValue() {
        return this.oldValue;
    }
}

