/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.api.RFuture;
import org.redisson.client.RedisClient;
import org.redisson.client.RedisConnection;
import org.redisson.client.RedisConnectionException;
import org.redisson.client.RedisException;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.config.BaseMasterSlaveServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.misc.RedisURI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReplicatedConnectionManager
extends MasterSlaveConnectionManager {
    private static final String ROLE_KEY = "role";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private AtomicReference<RedisURI> currentMaster = new AtomicReference();
    private ScheduledFuture<?> monitorFuture;

    public ReplicatedConnectionManager(ReplicatedServersConfig cfg, Config config, UUID id) {
        super(config, id);
        this.config = this.create(cfg);
        this.initTimer(this.config);
        for (String address : cfg.getNodeAddresses()) {
            RedisURI addr = new RedisURI(address);
            RFuture<RedisConnection> connectionFuture = this.connectToNode(cfg, addr, addr.getHost());
            connectionFuture.awaitUninterruptibly();
            RedisConnection connection = connectionFuture.getNow();
            if (connection == null) continue;
            Role role = Role.valueOf(connection.sync(RedisCommands.INFO_REPLICATION, new Object[0]).get(ROLE_KEY));
            if (Role.master.equals((Object)role)) {
                if (this.currentMaster.get() != null) {
                    this.stopThreads();
                    throw new RedisException("Multiple masters detected");
                }
                this.currentMaster.set(addr);
                this.log.info("{} is the master", (Object)addr);
                this.config.setMasterAddress(addr.toString());
                continue;
            }
            this.log.info("{} is a slave", (Object)addr);
            this.config.addSlaveAddress(addr.toString());
        }
        if (this.currentMaster.get() == null) {
            this.stopThreads();
            throw new RedisConnectionException("Can't connect to servers!");
        }
        if (this.config.getReadMode() != ReadMode.MASTER && this.config.getSlaveAddresses().isEmpty()) {
            this.log.warn("ReadMode = " + (Object)((Object)this.config.getReadMode()) + ", but slave nodes are not found! Please specify all nodes in replicated mode.");
        }
        this.initSingleEntry();
        this.scheduleMasterChangeCheck(cfg);
    }

    @Override
    protected MasterSlaveServersConfig create(BaseMasterSlaveServersConfig<?> cfg) {
        MasterSlaveServersConfig res = super.create(cfg);
        res.setDatabase(((ReplicatedServersConfig)cfg).getDatabase());
        return res;
    }

    private void scheduleMasterChangeCheck(final ReplicatedServersConfig cfg) {
        if (this.isShuttingDown()) {
            return;
        }
        this.monitorFuture = this.group.schedule(new Runnable(){

            @Override
            public void run() {
                if (ReplicatedConnectionManager.this.isShuttingDown()) {
                    return;
                }
                RedisURI master = (RedisURI)ReplicatedConnectionManager.this.currentMaster.get();
                ReplicatedConnectionManager.this.log.debug("Current master: {}", (Object)master);
                AtomicInteger count = new AtomicInteger(cfg.getNodeAddresses().size());
                for (String address : cfg.getNodeAddresses()) {
                    RedisURI addr = new RedisURI(address);
                    RFuture<RedisConnection> connectionFuture = ReplicatedConnectionManager.this.connectToNode(cfg, addr, addr.getHost());
                    connectionFuture.onComplete((connection, exc) -> {
                        if (exc != null) {
                            ReplicatedConnectionManager.this.log.error(exc.getMessage(), (Throwable)exc);
                            if (count.decrementAndGet() == 0) {
                                ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                            }
                            return;
                        }
                        if (ReplicatedConnectionManager.this.isShuttingDown()) {
                            return;
                        }
                        RFuture result = connection.async(RedisCommands.INFO_REPLICATION, new Object[0]);
                        result.onComplete((r, ex) -> {
                            if (ex != null) {
                                ReplicatedConnectionManager.this.log.error(ex.getMessage(), (Throwable)ex);
                                ReplicatedConnectionManager.this.closeNodeConnection((RedisConnection)connection);
                                if (count.decrementAndGet() == 0) {
                                    ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                                }
                                return;
                            }
                            Role role = Role.valueOf((String)r.get(ReplicatedConnectionManager.ROLE_KEY));
                            if (Role.master.equals((Object)role)) {
                                if (master.equals(addr)) {
                                    ReplicatedConnectionManager.this.log.debug("Current master {} unchanged", (Object)master);
                                } else if (ReplicatedConnectionManager.this.currentMaster.compareAndSet(master, addr)) {
                                    RFuture<RedisClient> changeFuture = ReplicatedConnectionManager.this.changeMaster(ReplicatedConnectionManager.this.singleSlotRange.getStartSlot(), addr);
                                    changeFuture.onComplete((res, e) -> {
                                        if (e != null) {
                                            ReplicatedConnectionManager.this.currentMaster.compareAndSet(addr, master);
                                        }
                                    });
                                }
                            } else if (!ReplicatedConnectionManager.this.config.checkSkipSlavesInit()) {
                                ReplicatedConnectionManager.this.slaveUp(addr, connection.getRedisClient().getAddr());
                            }
                            if (count.decrementAndGet() == 0) {
                                ReplicatedConnectionManager.this.scheduleMasterChangeCheck(cfg);
                            }
                        });
                    });
                }
            }
        }, (long)cfg.getScanInterval(), TimeUnit.MILLISECONDS);
    }

    private void slaveUp(RedisURI uri, InetSocketAddress address) {
        MasterSlaveEntry entry = this.getEntry(this.singleSlotRange.getStartSlot());
        if (entry.slaveUp(address, ClientConnectionsEntry.FreezeReason.MANAGER)) {
            this.log.info("slave: {} is up", (Object)uri);
        }
    }

    @Override
    public void shutdown() {
        if (this.monitorFuture != null) {
            this.monitorFuture.cancel(true);
        }
        this.closeNodeConnections();
        super.shutdown();
    }

    private static enum Role {
        master,
        slave;

    }
}

