/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.support;

import java.util.List;
import org.redisson.spring.support.AbstractRedissonNamespaceDefinitionParser;
import org.redisson.spring.support.RedissonNamespaceParserSupport;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConstructorArgumentValues;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class RedissonMultiLockDefinitionParser
extends AbstractRedissonNamespaceDefinitionParser {
    public RedissonMultiLockDefinitionParser(RedissonNamespaceParserSupport helper) {
        super(helper, "redisson-ref");
    }

    @Override
    protected void parseNested(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, BeanDefinition bd) {
        bd.setDependsOn(new String[]{element.getAttribute("redisson-ref")});
        List childElements = DomUtils.getChildElements((Element)element);
        for (Element elt : childElements) {
            String id;
            String localName = elt.getLocalName();
            if ("qualifier".equals(localName)) continue;
            if ("ref".equals(localName)) {
                id = elt.getAttribute("bean");
            } else {
                if (!elt.hasAttribute("redisson-ref")) {
                    this.helper.setAttribute(elt, "redisson-ref", element.getAttribute("redisson-ref"));
                }
                this.helper.populateIdAttribute(elt, builder, parserContext);
                parserContext.getDelegate().parseCustomElement(elt, bd);
                id = elt.getAttribute("id");
            }
            ConstructorArgumentValues args = builder.getRawBeanDefinition().getConstructorArgumentValues();
            if (args.getArgumentCount() > 0) {
                ManagedList list;
                ConstructorArgumentValues.ValueHolder value = (ConstructorArgumentValues.ValueHolder)args.getIndexedArgumentValues().get(0);
                if (value.getValue() instanceof ManagedList) {
                    list = (ManagedList)value.getValue();
                } else {
                    list = new ManagedList();
                    list.add(value.getValue());
                    value.setValue((Object)list);
                    value.setType(ManagedList.class.getName());
                }
                list.add((Object)new RuntimeBeanReference(id));
                continue;
            }
            builder.addConstructorArgReference(id);
        }
    }

    protected String getBeanClassName(Element element) {
        String elementName = Conventions.attributeNameToPropertyName((String)element.getLocalName());
        return "org.redisson.Redisson" + StringUtils.capitalize((String)elementName);
    }
}

