/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.pubsub;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.redisson.PubSubEntry;
import org.redisson.api.RFuture;
import org.redisson.client.BaseRedisPubSubListener;
import org.redisson.client.ChannelName;
import org.redisson.client.RedisPubSubListener;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.pubsub.PubSubType;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.misc.TransferListener;
import org.redisson.pubsub.AsyncSemaphore;
import org.redisson.pubsub.PublishSubscribeService;

abstract class PublishSubscribe<E extends PubSubEntry<E>> {
    private final ConcurrentMap<String, E> entries = new ConcurrentHashMap<String, E>();
    private final PublishSubscribeService service;

    PublishSubscribe(PublishSubscribeService service) {
        this.service = service;
    }

    public void unsubscribe(E entry, String entryName, String channelName) {
        AsyncSemaphore semaphore = this.service.getSemaphore(new ChannelName(channelName));
        semaphore.acquire(() -> {
            if (entry.release() == 0) {
                boolean removed;
                boolean bl = removed = this.entries.remove(entryName) == entry;
                if (!removed) {
                    throw new IllegalStateException();
                }
                this.service.unsubscribe(new ChannelName(channelName), semaphore);
            } else {
                semaphore.release();
            }
        });
    }

    public RFuture<E> subscribe(String entryName, String channelName) {
        AsyncSemaphore semaphore = this.service.getSemaphore(new ChannelName(channelName));
        RedissonPromise newPromise = new RedissonPromise();
        semaphore.acquire(() -> {
            if (!newPromise.setUncancellable()) {
                semaphore.release();
                return;
            }
            PubSubEntry entry = (PubSubEntry)this.entries.get(entryName);
            if (entry != null) {
                entry.acquire();
                semaphore.release();
                entry.getPromise().onComplete(new TransferListener(newPromise));
                return;
            }
            E value = this.createEntry(newPromise);
            value.acquire();
            PubSubEntry oldValue = (PubSubEntry)this.entries.putIfAbsent(entryName, value);
            if (oldValue != null) {
                oldValue.acquire();
                semaphore.release();
                oldValue.getPromise().onComplete(new TransferListener(newPromise));
                return;
            }
            RedisPubSubListener<Object> listener = this.createListener(channelName, value);
            this.service.subscribe((Codec)LongCodec.INSTANCE, channelName, semaphore, listener);
        });
        return newPromise;
    }

    protected abstract E createEntry(RPromise<E> var1);

    protected abstract void onMessage(E var1, Long var2);

    private RedisPubSubListener<Object> createListener(final String channelName, E value) {
        BaseRedisPubSubListener listener = new BaseRedisPubSubListener((PubSubEntry)value){
            final /* synthetic */ PubSubEntry val$value;
            {
                this.val$value = pubSubEntry;
            }

            @Override
            public void onMessage(CharSequence channel, Object message) {
                if (!channelName.equals(channel.toString())) {
                    return;
                }
                PublishSubscribe.this.onMessage(this.val$value, (Long)message);
            }

            @Override
            public boolean onStatus(PubSubType type, CharSequence channel) {
                if (!channelName.equals(channel.toString())) {
                    return false;
                }
                if (type == PubSubType.SUBSCRIBE) {
                    this.val$value.getPromise().trySuccess(this.val$value);
                    return true;
                }
                return false;
            }
        };
        return listener;
    }
}

