/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Arrays;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.redisson.PubSubEntry;
import org.redisson.RedissonExpirable;
import org.redisson.RedissonLockEntry;
import org.redisson.api.RFuture;
import org.redisson.api.RSemaphore;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.IntegerCodec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.misc.RPromise;
import org.redisson.misc.RedissonPromise;
import org.redisson.pubsub.SemaphorePubSub;

public class RedissonSemaphore
extends RedissonExpirable
implements RSemaphore {
    private final SemaphorePubSub semaphorePubSub;
    final CommandAsyncExecutor commandExecutor;

    public RedissonSemaphore(CommandAsyncExecutor commandExecutor, String name) {
        super(commandExecutor, name);
        this.commandExecutor = commandExecutor;
        this.semaphorePubSub = commandExecutor.getConnectionManager().getSubscribeService().getSemaphorePubSub();
    }

    String getChannelName() {
        return RedissonSemaphore.getChannelName(this.getName());
    }

    public static String getChannelName(String name) {
        if (name.contains("{")) {
            return "redisson_sc:" + name;
        }
        return "redisson_sc:{" + name + "}";
    }

    @Override
    public void acquire() throws InterruptedException {
        this.acquire(1);
    }

    @Override
    public void acquire(int permits) throws InterruptedException {
        if (this.tryAcquire(permits)) {
            return;
        }
        RFuture<RedissonLockEntry> future = this.subscribe();
        this.commandExecutor.syncSubscriptionInterrupted(future);
        try {
            while (true) {
                if (this.tryAcquire(permits)) {
                    return;
                }
                future.getNow().getLatch().acquire(permits);
            }
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<Void> acquireAsync() {
        return this.acquireAsync(1);
    }

    @Override
    public RFuture<Void> acquireAsync(int permits) {
        RedissonPromise<Void> result = new RedissonPromise<Void>();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                if (!result.trySuccess(null)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            RFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            subscribeFuture.onComplete((r, e1) -> {
                if (e1 != null) {
                    result.tryFailure((Throwable)e1);
                    return;
                }
                this.acquireAsync(permits, subscribeFuture, result);
            });
        });
        return result;
    }

    private void tryAcquireAsync(final AtomicLong time, final int permits, final RFuture<RedissonLockEntry> subscribeFuture, final RPromise<Boolean> result) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        if (time.get() <= 0L) {
            this.unsubscribe(subscribeFuture);
            result.trySuccess(false);
            return;
        }
        long curr = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.onComplete((res, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture);
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                this.unsubscribe(subscribeFuture);
                if (!result.trySuccess(true)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            long el = System.currentTimeMillis() - curr;
            time.addAndGet(-el);
            if (time.get() <= 0L) {
                this.unsubscribe(subscribeFuture);
                result.trySuccess(false);
                return;
            }
            final long current = System.currentTimeMillis();
            final RedissonLockEntry entry = (RedissonLockEntry)subscribeFuture.getNow();
            if (entry.getLatch().tryAcquire()) {
                this.tryAcquireAsync(time, permits, subscribeFuture, result);
            } else {
                AtomicBoolean executed = new AtomicBoolean();
                AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
                final Runnable listener = () -> {
                    executed.set(true);
                    if (futureRef.get() != null && !((Timeout)futureRef.get()).cancel()) {
                        entry.getLatch().release();
                        return;
                    }
                    long elapsed = System.currentTimeMillis() - current;
                    time.addAndGet(-elapsed);
                    this.tryAcquireAsync(time, permits, subscribeFuture, result);
                };
                entry.addListener(listener);
                long t = time.get();
                if (!executed.get()) {
                    Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                        @Override
                        public void run(Timeout timeout) throws Exception {
                            if (entry.removeListener(listener)) {
                                long elapsed = System.currentTimeMillis() - current;
                                time.addAndGet(-elapsed);
                                RedissonSemaphore.this.tryAcquireAsync(time, permits, subscribeFuture, result);
                            }
                        }
                    }, t, TimeUnit.MILLISECONDS);
                    futureRef.set(scheduledFuture);
                }
            }
        });
    }

    private void acquireAsync(int permits, RFuture<RedissonLockEntry> subscribeFuture, RPromise<Void> result) {
        if (result.isDone()) {
            this.unsubscribe(subscribeFuture);
            return;
        }
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.onComplete((res, e) -> {
            if (e != null) {
                this.unsubscribe(subscribeFuture);
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                this.unsubscribe(subscribeFuture);
                if (!result.trySuccess(null)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            RedissonLockEntry entry = (RedissonLockEntry)subscribeFuture.getNow();
            if (entry.getLatch().tryAcquire(permits)) {
                this.acquireAsync(permits, subscribeFuture, result);
            } else {
                entry.addListener(() -> this.acquireAsync(permits, subscribeFuture, result));
            }
        });
    }

    @Override
    public boolean tryAcquire() {
        return this.tryAcquire(1);
    }

    @Override
    public boolean tryAcquire(int permits) {
        return this.get(this.tryAcquireAsync(permits));
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync() {
        return this.tryAcquireAsync(1);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        if (permits == 0) {
            return RedissonPromise.newSucceededFuture(true);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value ~= false and tonumber(value) >= tonumber(ARGV[1])) then local val = redis.call('decrby', KEYS[1], ARGV[1]); return 1; end; return 0;", Collections.singletonList(this.getName()), permits);
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(long waitTime, TimeUnit unit) {
        return this.tryAcquireAsync(1, waitTime, unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryAcquire(int permits, long waitTime, TimeUnit unit) throws InterruptedException {
        long time = unit.toMillis(waitTime);
        long current = System.currentTimeMillis();
        if (this.tryAcquire(permits)) {
            return true;
        }
        if ((time -= System.currentTimeMillis() - current) <= 0L) {
            return false;
        }
        current = System.currentTimeMillis();
        RFuture<RedissonLockEntry> future = this.subscribe();
        if (!future.await(time, TimeUnit.MILLISECONDS)) {
            return false;
        }
        try {
            if ((time -= System.currentTimeMillis() - current) <= 0L) {
                boolean bl = false;
                return bl;
            }
            do {
                current = System.currentTimeMillis();
                if (this.tryAcquire(permits)) {
                    boolean bl = true;
                    return bl;
                }
                if ((time -= System.currentTimeMillis() - current) <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                current = System.currentTimeMillis();
                future.getNow().getLatch().tryAcquire(permits, time, TimeUnit.MILLISECONDS);
            } while ((time -= System.currentTimeMillis() - current) > 0L);
            boolean bl = false;
            return bl;
        }
        finally {
            this.unsubscribe(future);
        }
    }

    @Override
    public RFuture<Boolean> tryAcquireAsync(int permits, long waitTime, TimeUnit unit) {
        final RedissonPromise<Boolean> result = new RedissonPromise<Boolean>();
        AtomicLong time = new AtomicLong(unit.toMillis(waitTime));
        long curr = System.currentTimeMillis();
        RFuture<Boolean> tryAcquireFuture = this.tryAcquireAsync(permits);
        tryAcquireFuture.onComplete((res, e) -> {
            if (e != null) {
                result.tryFailure((Throwable)e);
                return;
            }
            if (res.booleanValue()) {
                if (!result.trySuccess(true)) {
                    this.releaseAsync(permits);
                }
                return;
            }
            long elap = System.currentTimeMillis() - curr;
            time.addAndGet(-elap);
            if (time.get() <= 0L) {
                result.trySuccess(false);
                return;
            }
            long current = System.currentTimeMillis();
            AtomicReference<Timeout> futureRef = new AtomicReference<Timeout>();
            final RFuture<RedissonLockEntry> subscribeFuture = this.subscribe();
            subscribeFuture.onComplete((r, ex) -> {
                if (ex != null) {
                    result.tryFailure((Throwable)ex);
                    return;
                }
                if (futureRef.get() != null) {
                    ((Timeout)futureRef.get()).cancel();
                }
                long elapsed = System.currentTimeMillis() - current;
                time.addAndGet(-elapsed);
                if (time.get() < 0L) {
                    this.unsubscribe(subscribeFuture);
                    result.trySuccess(false);
                    return;
                }
                this.tryAcquireAsync(time, permits, subscribeFuture, result);
            });
            if (!subscribeFuture.isDone()) {
                Timeout scheduledFuture = this.commandExecutor.getConnectionManager().newTimeout(new TimerTask(){

                    @Override
                    public void run(Timeout timeout) throws Exception {
                        if (!subscribeFuture.isDone()) {
                            result.trySuccess(false);
                        }
                    }
                }, time.get(), TimeUnit.MILLISECONDS);
                futureRef.set(scheduledFuture);
            }
        });
        return result;
    }

    private RFuture<RedissonLockEntry> subscribe() {
        return this.semaphorePubSub.subscribe(this.getName(), this.getChannelName());
    }

    private void unsubscribe(RFuture<RedissonLockEntry> future) {
        this.semaphorePubSub.unsubscribe((PubSubEntry)future.getNow(), this.getName(), this.getChannelName());
    }

    @Override
    public boolean tryAcquire(long time, TimeUnit unit) throws InterruptedException {
        return this.tryAcquire(1, time, unit);
    }

    @Override
    public void release() {
        this.release(1);
    }

    @Override
    public void release(int permits) {
        this.get(this.releaseAsync(permits));
    }

    @Override
    public RFuture<Void> releaseAsync() {
        return this.releaseAsync(1);
    }

    @Override
    public RFuture<Void> releaseAsync(int permits) {
        if (permits < 0) {
            throw new IllegalArgumentException("Permits amount can't be negative");
        }
        if (permits == 0) {
            return RedissonPromise.newSucceededFuture(null);
        }
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)StringCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('incrby', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], value); ", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public int drainPermits() {
        return this.get(this.drainPermitsAsync());
    }

    @Override
    public RFuture<Integer> drainPermitsAsync() {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)IntegerCodec.INSTANCE, RedisCommands.EVAL_LONG, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then return 0; end; redis.call('set', KEYS[1], 0); return value;", Collections.singletonList(this.getName()), new Object[0]);
    }

    @Override
    public int availablePermits() {
        return this.get(this.availablePermitsAsync());
    }

    @Override
    public RFuture<Integer> availablePermitsAsync() {
        return this.commandExecutor.writeAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.GET_INTEGER, this.getName());
    }

    @Override
    public boolean trySetPermits(int permits) {
        return this.get(this.trySetPermitsAsync(permits));
    }

    @Override
    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "local value = redis.call('get', KEYS[1]); if (value == false or value == 0) then redis.call('set', KEYS[1], ARGV[1]); redis.call('publish', KEYS[2], ARGV[1]); return 1;end;return 0;", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }

    @Override
    public void addPermits(int permits) {
        this.get(this.addPermitsAsync(permits));
    }

    @Override
    public RFuture<Void> addPermitsAsync(int permits) {
        return this.commandExecutor.evalWriteAsync(this.getName(), (Codec)LongCodec.INSTANCE, RedisCommands.EVAL_VOID, "local value = redis.call('get', KEYS[1]); if (value == false) then value = 0;end;redis.call('set', KEYS[1], value + ARGV[1]); ", Arrays.asList(this.getName(), this.getChannelName()), permits);
    }
}

