/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.redisson.api.Node;
import org.redisson.api.NodeType;
import org.redisson.api.NodesGroup;
import org.redisson.api.RFuture;
import org.redisson.client.RedisConnection;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.connection.ClientConnectionsEntry;
import org.redisson.connection.ConnectionListener;
import org.redisson.connection.ConnectionManager;
import org.redisson.connection.MasterSlaveEntry;
import org.redisson.connection.RedisClientEntry;
import org.redisson.misc.RedisURI;

@Deprecated
public class RedisNodes<N extends Node>
implements NodesGroup<N> {
    final ConnectionManager connectionManager;

    public RedisNodes(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    @Override
    public N getNode(String address) {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        RedisURI addr = new RedisURI(address);
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (masterSlaveEntry.getAllEntries().isEmpty() && RedisURI.compare(masterSlaveEntry.getClient().getAddr(), addr)) {
                return (N)new RedisClientEntry(masterSlaveEntry.getClient(), this.connectionManager.getCommandExecutor(), NodeType.MASTER);
            }
            for (ClientConnectionsEntry entry : masterSlaveEntry.getAllEntries()) {
                if (!RedisURI.compare(entry.getClient().getAddr(), addr) || entry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER) continue;
                return (N)new RedisClientEntry(entry.getClient(), this.connectionManager.getCommandExecutor(), entry.getNodeType());
            }
        }
        return null;
    }

    @Override
    public Collection<N> getNodes(NodeType type) {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        ArrayList<RedisClientEntry> result = new ArrayList<RedisClientEntry>();
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (masterSlaveEntry.getAllEntries().isEmpty() && type == NodeType.MASTER) {
                RedisClientEntry entry = new RedisClientEntry(masterSlaveEntry.getClient(), this.connectionManager.getCommandExecutor(), NodeType.MASTER);
                result.add(entry);
            }
            for (ClientConnectionsEntry slaveEntry : masterSlaveEntry.getAllEntries()) {
                if (slaveEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER || slaveEntry.getNodeType() != type) continue;
                RedisClientEntry entry = new RedisClientEntry(slaveEntry.getClient(), this.connectionManager.getCommandExecutor(), slaveEntry.getNodeType());
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public Collection<N> getNodes() {
        Collection<MasterSlaveEntry> entries = this.connectionManager.getEntrySet();
        ArrayList<RedisClientEntry> result = new ArrayList<RedisClientEntry>();
        for (MasterSlaveEntry masterSlaveEntry : entries) {
            if (masterSlaveEntry.getAllEntries().isEmpty()) {
                RedisClientEntry masterEntry = new RedisClientEntry(masterSlaveEntry.getClient(), this.connectionManager.getCommandExecutor(), NodeType.MASTER);
                result.add(masterEntry);
            }
            for (ClientConnectionsEntry slaveEntry : masterSlaveEntry.getAllEntries()) {
                if (slaveEntry.getFreezeReason() == ClientConnectionsEntry.FreezeReason.MANAGER) continue;
                RedisClientEntry entry = new RedisClientEntry(slaveEntry.getClient(), this.connectionManager.getCommandExecutor(), slaveEntry.getNodeType());
                result.add(entry);
            }
        }
        return result;
    }

    @Override
    public boolean pingAll(long timeout, TimeUnit timeUnit) {
        ArrayList<N> clients = new ArrayList<N>(this.getNodes());
        ConcurrentHashMap result = new ConcurrentHashMap(clients.size());
        CountDownLatch latch = new CountDownLatch(clients.size());
        for (RedisClientEntry entry : clients) {
            RFuture<RedisConnection> f = entry.getClient().connectAsync();
            f.onComplete((c, e) -> {
                if (c != null) {
                    RFuture r = c.async(timeUnit.toMillis(timeout), RedisCommands.PING, new Object[0]);
                    result.put(c, r);
                    latch.countDown();
                } else {
                    latch.countDown();
                }
            });
        }
        long time = System.currentTimeMillis();
        try {
            latch.await();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
        if (System.currentTimeMillis() - time >= (long)this.connectionManager.getConfig().getConnectTimeout()) {
            for (Map.Entry entry : result.entrySet()) {
                ((RedisConnection)entry.getKey()).closeAsync();
            }
            return false;
        }
        time = System.currentTimeMillis();
        boolean res = true;
        for (Map.Entry entry : result.entrySet()) {
            RFuture f = (RFuture)entry.getValue();
            f.awaitUninterruptibly();
            String pong = (String)f.getNow();
            ((RedisConnection)entry.getKey()).closeAsync();
            if ("PONG".equals(pong)) continue;
            res = false;
            break;
        }
        return res && result.size() == clients.size();
    }

    @Override
    public boolean pingAll() {
        return this.pingAll(1L, TimeUnit.SECONDS);
    }

    @Override
    public int addConnectionListener(ConnectionListener connectionListener) {
        return this.connectionManager.getConnectionEventsHub().addListener(connectionListener);
    }

    @Override
    public void removeConnectionListener(int listenerId) {
        this.connectionManager.getConnectionEventsHub().removeListener(listenerId);
    }
}

