/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.misc;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProxyBuilder {
    private static final ConcurrentMap<CacheKey, Method> METHODS_MAPPING = new ConcurrentHashMap<CacheKey, Method>();

    public static <T> T create(final Callback commandExecutor, final Object instance, final Object implementation, Class<T> clazz) {
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                CacheKey key = new CacheKey(method, instance.getClass());
                Method instanceMethod = (Method)METHODS_MAPPING.get(key);
                if (instanceMethod == null) {
                    if (implementation != null) {
                        try {
                            instanceMethod = implementation.getClass().getMethod(method.getName(), method.getParameterTypes());
                        }
                        catch (NoSuchMethodException e) {
                            try {
                                instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                            }
                            catch (Exception e2) {
                                instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                            }
                        }
                    } else {
                        try {
                            instanceMethod = instance.getClass().getMethod(method.getName() + "Async", method.getParameterTypes());
                        }
                        catch (NoSuchMethodException e) {
                            instanceMethod = instance.getClass().getMethod(method.getName(), method.getParameterTypes());
                        }
                    }
                    METHODS_MAPPING.put(key, instanceMethod);
                }
                Method mm = instanceMethod;
                if (instanceMethod.getName().endsWith("Async")) {
                    return commandExecutor.execute(mm, instance, method, args);
                }
                if (implementation != null && instanceMethod.getDeclaringClass().isAssignableFrom(implementation.getClass())) {
                    return instanceMethod.invoke(implementation, args);
                }
                return instanceMethod.invoke(instance, args);
            }
        };
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, handler);
    }

    private static class CacheKey {
        Method method;
        Class<?> instanceClass;

        CacheKey(Method method, Class<?> instanceClass) {
            this.method = method;
            this.instanceClass = instanceClass;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.instanceClass == null ? 0 : this.instanceClass.hashCode());
            result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CacheKey other = (CacheKey)obj;
            if (this.instanceClass == null ? other.instanceClass != null : !this.instanceClass.equals(other.instanceClass)) {
                return false;
            }
            return !(this.method == null ? other.method != null : !this.method.equals(other.method));
        }
    }

    public static interface Callback {
        public Object execute(Method var1, Object var2, Method var3, Object[] var4);
    }
}

